/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.ui;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ImageSearchResult;
import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageSearchPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageTagSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageSearchResultFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SearchDialogTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String IMAGE_TAG = "latest";
    private static final String EXPECTED_IMAGE_NAME = "busybox";

    @Before
    public void before() {
        SearchDialogTest.deleteAllConnections();
        this.getConnection();
        this.deleteImageIfExists("busybox", IMAGE_TAG);
        if (this.mockitoIsUsed()) {
            this.mockResults();
        }
    }

    @Test
    public void testSearchDialog() {
        DockerExplorerView explorer = new DockerExplorerView();
        explorer.open();
        AbstractWait.sleep((TimePeriod)TimePeriod.getCustom((long)5L));
        this.getConnection().openImageSearchDialog("busybox", null, "https://index.docker.io");
        ImageSearchPage pageOne = new ImageSearchPage((ReferencedComposite)explorer);
        pageOne.searchImage();
        Assert.assertFalse((String)"Search result is empty!", (boolean)pageOne.getSearchResults().isEmpty());
        Assert.assertTrue((String)"Search result do not contains image:busybox!", (boolean)pageOne.searchResultsContains("busybox"));
        pageOne.next();
        AbstractWait.sleep((TimePeriod)TimePeriod.getCustom((long)5L));
        ImageTagSelectionPage pageTwo = new ImageTagSelectionPage((ReferencedComposite)pageOne);
        if (!this.mockitoIsUsed()) {
            List tags = pageTwo.getTags();
            Assert.assertFalse((String)"Search tags are empty!", (boolean)tags.isEmpty());
            new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
            if (!pageTwo.tagsContains(IMAGE_TAG)) {
                pageTwo.cancel();
                new CancelButton().click();
                Assert.fail((String)("Search results do not contain tag: latest! Page contains tags: " + tags.toString()));
            }
            pageTwo.selectTag(IMAGE_TAG);
            pageTwo.cancel();
        } else {
            pageTwo.cancel();
        }
        new PushButton("Cancel").click();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    private void mockResults() {
        DockerClient client = MockDockerClientFactory.onSearch((String)"busybox", (ImageSearchResult[])new ImageSearchResult[]{MockImageSearchResultFactory.name((String)"busybox:latest").build(), MockImageSearchResultFactory.name((String)"busybox").build()}).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        IDockerImage image = MockDockerImageFactory.name((String)"busybox:latest", (String[])new String[0]).connection((IDockerConnection)dockerConnection).build();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }
}

