/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.Image;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.junit.Assert;
import org.junit.Test;

public class DockerConnectionTest {
    @Test
    public void shouldLoadContainers() throws DockerException {
        Container fooContainer = MockContainerFactory.id("foo").build();
        Container barContainer = MockContainerFactory.id("bar").build();
        DockerClient client = MockDockerClientFactory.container(fooContainer).container(barContainer).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        dockerConnection.open(false);
        List containers = dockerConnection.getContainers();
        Assertions.assertThat((List)containers).hasSize(2);
    }

    @Test
    public void shouldLoadImages() throws DockerException {
        Image fooImage = MockImageFactory.id("foo").build();
        Image barImage = MockImageFactory.id("bar").build();
        DockerClient client = MockDockerClientFactory.image(fooImage).image(barImage).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        dockerConnection.open(false);
        List images = dockerConnection.getImages();
        Assertions.assertThat((List)images).hasSize(2);
    }

    @Test
    public void hasImageTest() throws DockerException {
        Image fooImage = MockImageFactory.id("foo").name("foo", "foo:latest", "foo:1.0", "org/foo", "org/foo:1.0", "org/foo:latest").build();
        DockerClient client = MockDockerClientFactory.image(fooImage).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        dockerConnection.open(false);
        Assert.assertTrue((boolean)dockerConnection.hasImage("foo", null));
        Assert.assertTrue((boolean)dockerConnection.hasImage("foo", "latest"));
        Assert.assertTrue((boolean)dockerConnection.hasImage("foo", "1.0"));
        Assert.assertTrue((boolean)dockerConnection.hasImage("org/foo", null));
        Assert.assertTrue((boolean)dockerConnection.hasImage("org/foo", "latest"));
        Assert.assertTrue((boolean)dockerConnection.hasImage("org/foo", "1.0"));
    }

    @Test
    public void shouldBeClosedWhenInvalidPathToCerts() {
        DockerConnection dockerConnection = new DockerConnection.Builder().name("foo").tcpConnection(new TCPConnectionSettings("https://1.2.3.4:1234", "/invalid/path"));
        try {
            dockerConnection.open(false);
            Assert.fail((String)"Expected an exception since the path to certs is invalid");
        }
        catch (DockerException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(DockerCertificateException.class);
        }
        Assertions.assertThat((Comparable)dockerConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.CLOSED);
    }
}

