/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;

public class DockerImageAssertions
extends AbstractAssert<DockerImageAssertions, IDockerImage> {
    public static DockerImageAssertions assertThat(IDockerImage image) {
        return new DockerImageAssertions(image);
    }

    protected DockerImageAssertions(IDockerImage actual) {
        super((Object)actual, DockerImageAssertions.class);
    }

    public DockerImageAssertions is(DockerImage.DockerImageQualifier qualifier) {
        switch (qualifier) {
            case DANGLING: {
                DockerImageAssertions.assertThat((IDockerImage)this.actual).isDanglingImage();
                break;
            }
            case INTERMEDIATE: {
                DockerImageAssertions.assertThat((IDockerImage)this.actual).isIntermediateImage();
                break;
            }
            case TOP_LEVEL: {
                DockerImageAssertions.assertThat((IDockerImage)this.actual).isTopLevelImage();
            }
        }
        return this;
    }

    public DockerImageAssertions isTopLevelImage() {
        this.isNotNull();
        if (((IDockerImage)this.actual).isDangling() || ((IDockerImage)this.actual).isIntermediateImage()) {
            Assertions.fail((String)("Expected images '" + ((IDockerImage)this.actual).repo() + "' to be a top-level images but it was not."));
        }
        return this;
    }

    public DockerImageAssertions isIntermediateImage() {
        this.isNotNull();
        if (!((IDockerImage)this.actual).isIntermediateImage()) {
            Assertions.fail((String)("Expected images '" + ((IDockerImage)this.actual).repo() + "' to be an intermediate images but it was not."));
        }
        return this;
    }

    public DockerImageAssertions isDanglingImage() {
        this.isNotNull();
        if (!((IDockerImage)this.actual).isDangling()) {
            Assertions.fail((String)("Expected images '" + ((IDockerImage)this.actual).repo() + "' to be a danglingimage but it was not."));
        }
        return this;
    }
}

