/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.docker.ui.testutils.RunWithProject;
import org.eclipse.linuxtools.internal.docker.ui.testutils.SyncFileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ProjectInitializationRule
extends ExternalResource {
    private Description description;
    private IProject project = null;

    public IProject getProject() {
        return this.project;
    }

    public Statement apply(Statement base, Description description) {
        this.description = description;
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        if (this.description == null) {
            Assert.fail((String)"No method description available while trying to setup test project");
        }
        String projectName = this.getProjectName();
        IWorkspace junitWorkspace = ResourcesPlugin.getWorkspace();
        this.project = ProjectInitializationRule.getTargetWorkspaceProject(ProjectInitializationRule.getSampleProjectPath(projectName), junitWorkspace);
    }

    private String getProjectName() throws NoSuchMethodException, ClassNotFoundException {
        String className = this.description.getClassName();
        String methodName = this.description.getMethodName();
        Class<?> testClass = Class.forName(className);
        Method testMethod = testClass.getMethod(methodName, new Class[0]);
        RunWithProject runWithProjectMethodAnnotation = testMethod.getAnnotation(RunWithProject.class);
        if (runWithProjectMethodAnnotation != null) {
            return runWithProjectMethodAnnotation.value();
        }
        RunWithProject runWithProjectTypeAnnotation = testClass.getAnnotation(RunWithProject.class);
        if (runWithProjectTypeAnnotation != null) {
            return runWithProjectTypeAnnotation.value();
        }
        Assert.fail((String)("No '@RunWithProject' annotation found while running test " + className + "." + methodName));
        return null;
    }

    public static IPath getSampleProjectPath(String projectName) {
        if (System.getProperty("user.dir") != null) {
            return new Path(System.getProperty("user.dir")).append("projects").append(projectName).makeAbsolute();
        }
        Assert.fail((String)("The sample project was not found in the launcher workspace under name '" + projectName + "'"));
        return null;
    }

    public static IProject getTargetWorkspaceProject(IPath projectSourcePath, IWorkspace targetWorkspace) throws CoreException, InvocationTargetException, InterruptedException {
        IPath dotProjectPath = projectSourcePath.addTrailingSeparator().append(".project");
        IProjectDescription description = targetWorkspace.loadProjectDescription(dotProjectPath);
        String projectName = description.getName();
        IProject project = targetWorkspace.getRoot().getProject(projectName);
        if (project.exists() && !targetWorkspace.getRoot().getFile(project.getFile(".project").getFullPath()).exists()) {
            project.delete(true, null);
        } else if (project.exists() && !project.isOpen()) {
            project.open(null);
        } else if (!project.exists()) {
            ProjectInitializationRule.createProject(description, projectName, targetWorkspace, project);
            SyncFileSystemStructureProvider syncFileSystemStructureProvider = new SyncFileSystemStructureProvider.Builder(projectSourcePath, project.getLocation()).ignoreRelativeSourcePaths(".svn", ".git", "target", "bin").build();
            List<File> filesToImport = syncFileSystemStructureProvider.getChildren(projectSourcePath.toFile());
            if (filesToImport != null && filesToImport.size() > 0) {
                ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)projectSourcePath.toFile(), (IImportStructureProvider)syncFileSystemStructureProvider, pathString -> "YES", filesToImport);
                operation.setContext(null);
                operation.setOverwriteResources(true);
                operation.setCreateContainerStructure(false);
                operation.run(null);
            }
        }
        return project;
    }

    static void createProject(IProjectDescription description, String projectName, IWorkspace workspace, IProject project) throws InvocationTargetException, OperationCanceledException, CoreException, InterruptedException {
        IProjectDescription desc = workspace.newProjectDescription(projectName);
        desc.setBuildSpec(description.getBuildSpec());
        desc.setComment(description.getComment());
        desc.setDynamicReferences(description.getDynamicReferences());
        desc.setNatureIds(description.getNatureIds());
        desc.setReferencedProjects(description.getReferencedProjects());
        try {
            project.create(desc, null);
            project.open(128, null);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        ProjectInitializationRule.buildProject(project);
    }

    public static void buildProject(IProject project) throws CoreException, OperationCanceledException, InterruptedException {
        project.refreshLocal(2, null);
        project.build(6, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
    }
}

