/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.AbstractSWTBotAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.hamcrest.Matchers;

public class SWTBotTreeItemAssertions
extends AbstractSWTBotAssertions<SWTBotTreeItemAssertions, SWTBotTreeItem> {
    protected SWTBotTreeItemAssertions(SWTBotTreeItem actual) {
        super(actual, SWTBotTreeItemAssertions.class);
    }

    public static SWTBotTreeItemAssertions assertThat(SWTBotTreeItem containerPortsTreeItem) {
        return new SWTBotTreeItemAssertions(containerPortsTreeItem);
    }

    public SWTBotTreeItemAssertions isExpanded() {
        Matchers.notNullValue();
        if (!((SWTBotTreeItem)this.actual).isExpanded()) {
            this.failWithMessage("Expected tree item %s to be expanded but it was not.", new Object[]{((SWTBotTreeItem)this.actual).getText()});
        }
        return this;
    }

    public SWTBotTreeItemAssertions hasChildItems(int expectedCount) {
        Matchers.notNullValue();
        if (((SWTBotTreeItem)this.actual).getItems().length != expectedCount) {
            this.failWithMessage("Expected tree item %s to be have %s items but it had %s.", new Object[]{((SWTBotTreeItem)this.actual).getText(), expectedCount, ((SWTBotTreeItem)this.actual).getItems().length});
        }
        SWTBotTreeItem[] sWTBotTreeItemArray = ((SWTBotTreeItem)this.actual).getItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem swtBotTreeItem = sWTBotTreeItemArray[n2];
            String treeItemText = SWTUtils.syncExec(() -> swtBotTreeItem.getText());
            Image treeItemWidgetImage = SWTUtils.syncExec(() -> ((TreeItem)sWTBotTreeItem.widget).getImage());
            Assertions.assertThat((String)treeItemText).isNotNull();
            Assertions.assertThat((Object)treeItemWidgetImage).isNotNull();
            ++n2;
        }
        return this;
    }

    public SWTBotTreeItemAssertions hasText(String expectedText) {
        Matchers.notNullValue();
        if (!((SWTBotTreeItem)this.actual).getText().equals(expectedText)) {
            this.failWithMessage("Expected node to have text %s but it was %s", new Object[]{expectedText, ((SWTBotTreeItem)this.actual).getText()});
        }
        return this;
    }
}

