/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.ui.resources;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.linuxtools.docker.reddeer.ui.AbstractDockerExplorerItem;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.DockerContainer;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.DockerImage;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.exception.JFaceLayerException;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ControlIsEnabled;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class DockerConnection
extends AbstractDockerExplorerItem {
    private static final String IMAGE_NAME_LABEL_DIALOG = "Image name:";

    public DockerConnection(TreeItem treeItem) {
        super(treeItem);
    }

    public void enableConnection() {
        this.select();
        new DefaultToolItem("Enable Connection").click();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public DockerImage getImage(String imageName) {
        return this.getImage(imageName, "latest");
    }

    public DockerImage getImage(String imageName, String tag) {
        try {
            List images = this.treeViewerHandler.getTreeItems(this.item, new String[]{"Images", String.valueOf(imageName) + ":"});
            for (TreeItem item : images) {
                if (!this.hasTag(tag, item)) continue;
                return new DockerImage(item);
            }
        }
        catch (JFaceLayerException jFaceLayerException) {
            // empty catch block
        }
        return null;
    }

    private boolean hasTag(String tag, TreeItem item) {
        String[] styledTexts = this.treeViewerHandler.getStyledTexts(item);
        if (styledTexts == null || styledTexts.length == 0) {
            return false;
        }
        return StringUtils.contains((String)styledTexts[0].trim(), (String)tag);
    }

    public void refreshImages() {
        this.treeViewerHandler.getTreeItem(this.item, new String[]{"Images"}).select();
        new ContextMenu().getItem(new String[]{"Refresh"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public void refreshContainers() {
        this.treeViewerHandler.getTreeItem(this.item, new String[]{"Containers"}).select();
        new ContextMenu().getItem(new String[]{"Refresh"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public void refresh() {
        this.refreshImages();
        this.refreshContainers();
    }

    public void pullImage(String imageName) {
        this.pullImage(imageName, null, null);
    }

    public void pullImage(String imageName, String imageTag) {
        this.pullImage(imageName, imageTag, null);
    }

    public void pullImage(String imageName, String imageTag, String dockerRegister) {
        if (this.getImage(imageName, imageTag) == null) {
            this.refreshImages();
            this.treeViewerHandler.getTreeItem(this.item, new String[]{"Images"}).select();
            new ContextMenu().getItem(new String[]{"Pull..."}).select();
            new WaitUntil((WaitCondition)new ShellIsAvailable("Pull Image"), TimePeriod.DEFAULT);
            DefaultShell pullShell = new DefaultShell("Pull Image");
            if (dockerRegister != null) {
                DefaultCombo combo = new DefaultCombo();
                combo.setSelection(dockerRegister);
            }
            new LabeledText(IMAGE_NAME_LABEL_DIALOG).setFocus();
            new LabeledText(IMAGE_NAME_LABEL_DIALOG).setText(imageTag == null ? imageName : String.valueOf(imageName) + ":" + imageTag);
            new WaitUntil((WaitCondition)new ControlIsEnabled((Control)new FinishButton()));
            new FinishButton((ReferencedComposite)pullShell).click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)pullShell));
            new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        }
    }

    public void openImageSearchDialog(String imageName, String imageTag, String dockerRegister) {
        this.refreshImages();
        this.treeViewerHandler.getTreeItem(this.item, new String[]{"Images"}).select();
        new ContextMenu().getItem(new String[]{"Pull..."}).select();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Pull Image"), TimePeriod.DEFAULT);
        if (dockerRegister != null) {
            DefaultCombo combo = new DefaultCombo();
            combo.setSelection(dockerRegister);
        }
        new LabeledText(IMAGE_NAME_LABEL_DIALOG).setFocus();
        new LabeledText(IMAGE_NAME_LABEL_DIALOG).setText(imageTag == null ? imageName : String.valueOf(imageName) + ":" + imageTag);
        new PushButton("Search...").click();
    }

    public boolean imageIsDeployed(String imageName) {
        return this.deployedImagesCount(imageName) >= 1;
    }

    public int deployedImagesCount(String imageName) {
        int count = 0;
        this.select();
        List<String> imagesNames = this.getImagesNames(true);
        for (String imageNameFromList : imagesNames) {
            if (!imageNameFromList.contains(imageName)) continue;
            ++count;
        }
        return count;
    }

    public boolean containerIsDeployed(String containerName) {
        return this.getContainer(containerName) != null;
    }

    public void removeConnection() {
        this.select();
        new DefaultToolItem("Remove Connection").click();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public DockerContainer getContainer(String containerName) {
        try {
            List containers = this.treeViewerHandler.getTreeItems(this.item, new String[]{"Containers", containerName});
            return new DockerContainer((TreeItem)containers.get(0));
        }
        catch (JFaceLayerException ex) {
            return null;
        }
    }

    public List<String> getImagesNames() {
        return this.getImagesNames(false);
    }

    public List<String> getImagesNames(boolean withTag) {
        this.select();
        ArrayList<String> imagesNames = new ArrayList<String>();
        List images = this.treeViewerHandler.getTreeItem(this.item, new String[]{"Images"}).getItems();
        for (TreeItem item : images) {
            String imageName = this.treeViewerHandler.getNonStyledText(item);
            if (withTag) {
                String imageTag = this.getImageTag(item);
                imagesNames.add(String.valueOf(imageName) + imageTag);
                continue;
            }
            imagesNames.add(imageName);
        }
        return imagesNames;
    }

    private String getImageTag(TreeItem item) {
        String[] styledTexts = this.treeViewerHandler.getStyledTexts(item);
        if (styledTexts == null || styledTexts.length == 0) {
            return null;
        }
        return styledTexts[0];
    }

    public List<String> getContainersNames() {
        this.select();
        ArrayList<String> containersNames = new ArrayList<String>();
        List containers = this.treeViewerHandler.getTreeItem(this.item, new String[]{"Containers"}).getItems();
        for (TreeItem item : containers) {
            containersNames.add(this.treeViewerHandler.getNonStyledText(item));
        }
        return containersNames;
    }

    public String getName() {
        return this.treeViewerHandler.getNonStyledText(this.item);
    }
}

