/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.changelog.core.IParserChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.ChangeLogWriter;
import org.eclipse.linuxtools.internal.changelog.core.actions.ChangeLogAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class InsertChangeLogKeyHandler
extends ChangeLogAction
implements IHandler,
IWorkbenchWindowActionDelegate {
    private IEditorPart currentEditor;

    private String getEditorName() {
        if (this.currentEditor != null) {
            return this.returnQualifedEditor(this.currentEditor.getClass());
        }
        return "";
    }

    private String getEntryFilePath() {
        if (this.currentEditor != null) {
            return this.getDocumentLocation(this.currentEditor, false);
        }
        return "";
    }

    private String returnQualifedEditor(Class<?> className) {
        return className.toString().substring(className.getPackage().toString().length() - 1, className.toString().length());
    }

    private IEditorPart getChangelog() {
        IConfigurationElement formatterConfigElement = this.extensionManager.getFormatterConfigElement();
        if (formatterConfigElement.getAttribute("inFile").equalsIgnoreCase("true")) {
            return this.currentEditor;
        }
        IEditorPart changelog = null;
        IConfigurationElement nameElement = formatterConfigElement.getChildren()[0];
        if (nameElement.getAttribute("name") == null) {
            this.reportErr("Got non-name child with inFile set to False", null);
            return null;
        }
        this.pref_ChangeLogName = nameElement.getAttribute("name");
        changelog = this.getChangelog(this.getDocumentLocation(this.currentEditor, false));
        if (changelog == null) {
            changelog = this.askChangeLogLocation(this.getDocumentLocation(this.currentEditor, false));
        }
        return changelog;
    }

    private String parseFunctionName(IParserChangeLogContrib parser) {
        try {
            return parser.parseCurrentFunction(this.currentEditor);
        }
        catch (CoreException e) {
            this.reportErr("Couldn't parse function name with " + parser.getClass().toString(), null);
            return "";
        }
    }

    public Object execute(ExecutionEvent event) {
        this.currentEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (this.currentEditor == null) {
            return null;
        }
        ChangeLogWriter clw = new ChangeLogWriter();
        this.loadPreferences();
        clw.setEntryFilePath(this.getEntryFilePath());
        if (clw.getEntryFilePath() == "") {
            return null;
        }
        String editorName = this.getEditorName();
        IParserChangeLogContrib parser = this.extensionManager.getParserContributor(editorName);
        if (parser == null) {
            clw.setGuessedFName("");
        } else {
            clw.setGuessedFName(this.parseFunctionName(parser));
        }
        clw.setFormatter(this.extensionManager.getFormatterContributor(clw.getEntryFilePath(), this.pref_Formatter));
        clw.setChangelog(this.getChangelog());
        if (clw.getChangelog() == null) {
            return null;
        }
        clw.setDateLine(clw.getFormatter().formatDateLine(this.pref_AuthorName, this.pref_AuthorEmail));
        clw.setChangelogLocation(this.getDocumentLocation(clw.getChangelog(), true));
        clw.writeChangeLog();
        return null;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public boolean isEnabled() {
        IEditorReference[] refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            IEditorReference ref = refs[i];
            String id = ref.getId();
            System.out.println(id);
            ++i;
        }
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.execute(null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

