/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.IndentUtil;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPHeuristicScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPIndenter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class IndentHandler
extends AbstractHandler {
    private int fCaretOffset;
    private final boolean fIsTabAction = false;

    public Object execute(ExecutionEvent event) {
        if (!this.isEnabled()) {
            return null;
        }
        ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor == null || !editor.isEditable()) {
            return null;
        }
        ITextSelection selection = this.getSelection(editor);
        final IDocument document = this.getDocument(editor);
        if (document != null) {
            int nLines;
            int firstLine;
            final int offset = selection.getOffset();
            final int length = selection.getLength();
            final Position end = new Position(offset + length);
            this.fCaretOffset = -1;
            try {
                firstLine = document.getLineOfOffset(offset);
                int minusOne = length == 0 ? 0 : 1;
                nLines = document.getLineOfOffset(offset + length - minusOne) - firstLine + 1;
                document.addPosition(end);
            }
            catch (BadLocationException e) {
                IDEPlugin.log((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", 0, "", (Throwable)e));
                return null;
            }
            STPRunnable runnable = new STPRunnable(this, editor){

                @Override
                public void run() {
                    IRewriteTarget target = (IRewriteTarget)this.getTextEditor().getAdapter(IRewriteTarget.class);
                    if (target != null) {
                        target.beginCompoundChange();
                    }
                    try {
                        try {
                            int newLength;
                            int newOffset;
                            STPHeuristicScanner scanner = new STPHeuristicScanner(document);
                            STPIndenter indenter = new STPIndenter(document, scanner, this.getProject(this.getTextEditor()));
                            boolean multiLine = nLines > 1;
                            boolean hasChanged = false;
                            int i = 0;
                            while (i < nLines) {
                                hasChanged |= this.indentLine(document, firstLine + i, offset, indenter, scanner, multiLine);
                                ++i;
                            }
                            if (multiLine) {
                                newOffset = offset;
                                newLength = end.getOffset() - offset;
                            } else {
                                newOffset = fCaretOffset;
                                newLength = 0;
                            }
                            if (newOffset != -1 && (hasChanged || newOffset != offset || newLength != length)) {
                                this.selectAndReveal(this.getTextEditor(), newOffset, newLength);
                            }
                        }
                        catch (BadLocationException e) {
                            IDEPlugin.log((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", 0, "ConcurrentModification in IndentAction", (Throwable)e));
                            document.removePosition(end);
                            if (target != null) {
                                target.endCompoundChange();
                            }
                        }
                    }
                    finally {
                        document.removePosition(end);
                        if (target != null) {
                            target.endCompoundChange();
                        }
                    }
                }
            };
            if (nLines > 50) {
                Display display = editor.getEditorSite().getWorkbenchWindow().getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)runnable);
            } else {
                runnable.run();
            }
        }
        return null;
    }

    private void selectAndReveal(ITextEditor editor, int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        if (editor instanceof STPEditor) {
            ISourceViewer viewer = ((STPEditor)editor).getMySourceViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            editor.selectAndReveal(newOffset, newLength);
        }
    }

    private boolean indentLine(IDocument document, int line, int caret, STPIndenter indenter, STPHeuristicScanner scanner, boolean multiLine) throws BadLocationException {
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)offset, (boolean)false);
            String type = partition.getType();
            if (type.equals("__stp_multiline_comment")) {
                indent = this.computeCommentIndent(document, line, scanner, startingPartition);
            } else if (startingPartition.getType().equals("__stp_conditional")) {
                indent = this.computePreprocessorIndent(document, line, startingPartition);
            } else {
                if (startingPartition.getType().equals("__stp_string") && offset > startingPartition.getOffset()) {
                    return false;
                }
                if (startingPartition.getOffset() == offset && startingPartition.getType().equals("__stp_comment") && this.indentInsideLineComments()) {
                    int max = document.getLength() - offset;
                    int slashes = 2;
                    while (slashes < max - 1 && document.get(offset + slashes, 2).equals("//")) {
                        slashes += 2;
                    }
                    wsStart = offset + slashes;
                    StringBuilder computed = indenter.computeIndentation(offset);
                    if (computed == null) {
                        computed = new StringBuilder(0);
                    }
                    int tabSize = this.getTabSize();
                    while (slashes > 0 && computed.length() > 0) {
                        char c = computed.charAt(0);
                        if (c == '\t') {
                            if (slashes <= tabSize) break;
                            slashes -= tabSize;
                        } else {
                            if (c != ' ') break;
                            --slashes;
                        }
                        computed.deleteCharAt(0);
                    }
                    indent = String.valueOf(document.get(offset, wsStart - offset)) + computed;
                }
            }
        }
        if (indent == null) {
            StringBuilder computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : "";
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
            if (multiLine && !this.indentEmptyLines()) {
                indent = "";
            }
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        this.fCaretOffset = caret >= offset && caret <= end ? offset + indent.length() : -1;
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            return true;
        }
        return false;
    }

    private String computeCommentIndent(IDocument document, int line, STPHeuristicScanner scanner, ITypedRegion partition) throws BadLocationException {
        return IndentUtil.computeCommentIndent(document, line, scanner, partition);
    }

    private String computePreprocessorIndent(IDocument document, int line, ITypedRegion partition) throws BadLocationException {
        return IndentUtil.computePreprocessorIndent(document, line, partition);
    }

    private int getTabSize() {
        return this.getCoreFormatterOption(4);
    }

    private boolean indentEmptyLines() {
        return "true".equals(this.getCoreFormatterOption());
    }

    private boolean indentInsideLineComments() {
        return "true".equals(this.getCoreFormatterOption());
    }

    private String getCoreFormatterOption() {
        return "false";
    }

    private int getCoreFormatterOption(int def) {
        try {
            return Integer.parseInt(this.getCoreFormatterOption());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    private ISelectionProvider getSelectionProvider(ITextEditor editor) {
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    private IDocument getDocument(ITextEditor editor) {
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection(ITextEditor editor) {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider(editor);
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    private class STPRunnable
    implements Runnable {
        private ITextEditor editor;

        public STPRunnable(ITextEditor editor) {
            this.editor = editor;
        }

        public ITextEditor getTextEditor() {
            return this.editor;
        }

        @Override
        public void run() {
        }
    }
}

