/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.AbstractDataManipulator;
import org.eclipse.linuxtools.internal.perf.Messages;
import org.eclipse.linuxtools.internal.perf.handlers.PerfSaveStatsHandler;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatData
extends AbstractDataManipulator {
    private String prog;
    private String[] args;
    private int runCount;
    private String[] events;

    public StatData(String title, IPath workDir, String prog, String[] args, int runCount, String[] events, IProject project) {
        super(title, workDir, project);
        this.prog = prog;
        this.args = args;
        this.runCount = runCount;
        this.events = events;
    }

    @Override
    public void parse() {
        try {
            String prefix = "perf.stat".replace('.', '-');
            String file = Files.createTempFile(prefix, "", new FileAttribute[0]).toString();
            String[] cmd = this.getCommand(this.prog, this.args, file);
            this.performCommand(cmd, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String[] getCommand(String prog, String[] args, String file) {
        ArrayList<String> ret = new ArrayList<String>(Arrays.asList("perf", "stat"));
        if (this.runCount > 1) {
            ret.add("-r");
            ret.add(String.valueOf(this.runCount));
        }
        if (this.events != null) {
            String[] stringArray = this.events;
            int n = this.events.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                ret.add("-e");
                ret.add(event);
                ++n2;
            }
        }
        ret.add("-o");
        ret.add(file);
        ret.add(prog);
        ret.addAll(Arrays.asList(args));
        return ret.toArray(new String[0]);
    }

    protected String getProgram() {
        return this.prog;
    }

    protected String[] getArguments() {
        return this.args;
    }

    public void updateStatData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("perf");
        stringBuilder.append("%s.");
        stringBuilder.append(PerfSaveStatsHandler.DATA_EXT);
        String statNameFormat = stringBuilder.toString();
        IPath workingDir = this.getWorkDir();
        String curStatName = String.format(statNameFormat, "");
        IPath curStatPath = workingDir.append(curStatName);
        IRemoteFileProxy proxy = null;
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(this.project);
            IFileStore curFileStore = proxy.getResource(curStatPath.toOSString());
            if (curFileStore.fetchInfo().exists()) {
                String oldStatName = String.format(statNameFormat, ".old");
                IPath oldStatPath = workingDir.append(oldStatName);
                IFileStore oldFileStore = proxy.getResource(oldStatPath.toOSString());
                if (oldFileStore.fetchInfo().exists()) {
                    oldFileStore.delete(0, null);
                }
                curFileStore.copy(oldFileStore, 0, null);
                curFileStore.delete(0, null);
            }
            PerfSaveStatsHandler saveStats = new PerfSaveStatsHandler();
            saveStats.saveData("perf");
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
    }
}

