/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.ssh.proxy.Activator;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHCommandLauncher;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteEnvProxyManager;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;

public class SSHProxyManager
implements IRemoteEnvProxyManager {
    private final String SCHEME_ID = "ssh";

    public IRemoteFileProxy getFileProxy(URI uri) {
        return new SSHFileProxy(this.sanitizeURI(uri));
    }

    public IRemoteFileProxy getFileProxy(IProject project) {
        return new SSHFileProxy(project.getLocationURI());
    }

    public IRemoteCommandLauncher getLauncher(URI uri) {
        return new SSHCommandLauncher(this.sanitizeURI(uri));
    }

    public IRemoteCommandLauncher getLauncher(IProject project) {
        return new SSHCommandLauncher(project.getLocationURI());
    }

    public String getOS(URI uri) throws CoreException {
        SSHCommandLauncher cmdLauncher = new SSHCommandLauncher(this.sanitizeURI(uri));
        Process p = cmdLauncher.execute((IPath)new Path("/bin/uname"), new String[]{"-s"}, new String[0], null, null);
        String os = "";
        try {
            InputStream in = p.getInputStream();
            int exit = p.waitFor();
            if (exit == 0) {
                int len;
                byte[] bytes = new byte[15];
                while ((len = in.read(bytes)) != -1) {
                    os = String.valueOf(os) + new String(bytes, 0, len);
                }
                os = os.substring(0, os.indexOf(10));
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return os;
    }

    public String getOS(IProject project) throws CoreException {
        URI uri = project.getLocationURI();
        return this.getOS(uri);
    }

    public Map<String, String> getEnv(URI uri) throws CoreException {
        Object error;
        Map<String, String> env = Collections.emptyMap();
        SSHCommandLauncher cmdLauncher = new SSHCommandLauncher(this.sanitizeURI(uri));
        Process p = cmdLauncher.execute((IPath)new Path("/bin/env"), new String[0], new String[0], null, null);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String errorLine = ((BufferedReader)error).readLine();
                    if (errorLine != null) {
                        throw new IOException(errorLine);
                    }
                    ((BufferedReader)error).close();
                }
                finally {
                    if (error != null) {
                        ((BufferedReader)error).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, e.getMessage(), "org.eclipse.linuxtools.ssh.proxy");
            Activator.getDefault().getLog().log((IStatus)status);
            return Collections.emptyMap();
        }
        Pattern variablePattern = Pattern.compile("^(.+)=([^\\(\\)\\s{].*|)$");
        try {
            error = null;
            Object var9_15 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String readLine = reader.readLine();
                while (readLine != null) {
                    Matcher m = variablePattern.matcher(readLine);
                    if (m.matches()) {
                        env.put(m.group(1), m.group(2));
                    }
                    readLine = reader.readLine();
                }
            }
            catch (Throwable throwable) {
                if (error == null) {
                    error = throwable;
                } else if (error != throwable) {
                    ((Throwable)error).addSuppressed(throwable);
                }
                throw error;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, e.getMessage(), "org.eclipse.linuxtools.ssh.proxy");
            Activator.getDefault().getLog().log((IStatus)status);
            return Collections.emptyMap();
        }
        return env;
    }

    public Map<String, String> getEnv(IProject project) throws CoreException {
        URI uri = project.getLocationURI();
        return this.getEnv(uri);
    }

    private URI sanitizeURI(URI uri) {
        if (uri != null && !uri.getScheme().equals("ssh")) {
            try {
                return new URI("ssh", uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
            }
            catch (URISyntaxException e) {
                Status status = new Status(4, e.getMessage(), "org.eclipse.linuxtools.ssh.proxy");
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return uri;
    }
}

