/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rdt.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.remote.core.IRemoteProcess;

public class RemoteProcessClosure {
    private static int fCounter = 0;
    private IRemoteProcess fProcess;
    private OutputStream fOutput;
    private OutputStream fError;
    private ReaderThread fOutputReader;
    private ReaderThread fErrorReader;

    public RemoteProcessClosure(IRemoteProcess process, OutputStream outputStream, OutputStream errorStream) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = errorStream;
    }

    public void runNonBlocking() {
        ThreadGroup group = new ThreadGroup("CBuilder" + fCounter++);
        InputStream stdin = this.fProcess.getInputStream();
        InputStream stderr = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(group, "OutputReader", stdin, this.fOutput);
        this.fErrorReader = new ReaderThread(group, "ErrorReader", stderr, this.fError);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader.close();
            this.fErrorReader.close();
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    protected static class ReaderThread
    extends Thread {
        private InputStream fInputStream;
        private OutputStream fOutputStream;
        private boolean fFinished = false;
        private String lineSeparator;

        public ReaderThread(ThreadGroup group, String name, InputStream in, OutputStream out) {
            super(group, name);
            this.fOutputStream = out;
            this.fInputStream = in;
            this.setDaemon(true);
            this.lineSeparator = System.getProperty("line.separator");
        }

        @Override
        public void run() {
            try {
                try {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
                        while ((line = reader.readLine()) != null) {
                            line = String.valueOf(line) + this.lineSeparator;
                            this.fOutputStream.write(line.getBytes());
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.fOutputStream.flush();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        try {
                            this.fInputStream.close();
                        }
                        catch (IOException iOException3) {}
                    }
                }
                finally {
                    try {
                        this.fOutputStream.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                this.complete();
            }
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }

        public void close() {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

