/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rdt.proxy;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rdt.proxy.Activator;
import org.eclipse.linuxtools.internal.rdt.proxy.RDTCommandLauncher;
import org.eclipse.linuxtools.internal.rdt.proxy.RDTFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteEnvProxyManager;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public class RDTProxyManager
implements IRemoteEnvProxyManager {
    public static final String SYNC_NATURE = "org.eclipse.ptp.rdt.sync.core.remoteSyncNature";

    public IRemoteFileProxy getFileProxy(URI uri) throws CoreException {
        return new RDTFileProxy(uri);
    }

    public IRemoteFileProxy getFileProxy(IProject project) throws CoreException {
        return new RDTFileProxy(project);
    }

    public IRemoteCommandLauncher getLauncher(URI uri) {
        return new RDTCommandLauncher(uri);
    }

    public IRemoteCommandLauncher getLauncher(IProject project) {
        return new RDTCommandLauncher(project);
    }

    public String getOS(URI uri) {
        IRemoteConnection connection = RDTProxyManager.getConnection(uri);
        String os = connection.getProperty("os.name");
        if (os == null || os.isEmpty()) {
            return "Linux";
        }
        return os;
    }

    public String getOS(IProject project) {
        URI uri = project.getLocationURI();
        return this.getOS(uri);
    }

    public Map<String, String> getEnv(URI uri) {
        IRemoteConnection connection = RDTProxyManager.getConnection(uri);
        if (!connection.isOpen()) {
            try {
                connection.open(null);
            }
            catch (RemoteConnectionException e) {
                IStatus status = Status.error((String)e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log(status);
                return Collections.emptyMap();
            }
        }
        Pattern variablePattern = Pattern.compile("^(.+)=([^\\(\\)\\s{].*|)$");
        HashMap<String, String> envMap = new HashMap<String, String>();
        IRemoteProcessService ps = (IRemoteProcessService)connection.getService(IRemoteProcessService.class);
        Map envTemp = ps.getEnv();
        for (Map.Entry entry : envTemp.entrySet()) {
            String env = String.valueOf((String)entry.getKey()) + '=' + (String)entry.getValue();
            Matcher m = variablePattern.matcher(env);
            if (!m.matches()) continue;
            envMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return envMap;
    }

    public Map<String, String> getEnv(IProject project) {
        URI uri = project.getLocationURI();
        return this.getEnv(uri);
    }

    public static IRemoteConnection getConnection(URI uri) {
        IRemoteServicesManager sm = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType ct = sm.getConnectionType(uri);
        return ct.getConnection(uri);
    }
}

