/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.ssh.proxy.Messages;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHPasswordDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SSHBase {
    private URI uri;
    private JSch jsch;
    private Session session;
    private ChannelSftp channelSftp;
    private static Map<String, String> passwords = new HashMap<String, String>();

    public SSHBase(URI uri) {
        this.uri = uri;
        this.jsch = new JSch();
    }

    private Session loadSession() throws CoreException {
        if (this.session == null || !this.session.isConnected()) {
            try {
                this.session = this.jsch.getSession(this.uri.getUserInfo(), this.uri.getHost());
            }
            catch (JSchException e) {
                throw new CoreException(Status.error((String)(String.valueOf(Messages.SSHBase_CreateSessionFailed) + e.getMessage())));
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            String password = passwords.get(this.uri.getAuthority());
            if (password != null) {
                this.session.setPassword(password);
                try {
                    this.session.connect();
                    return this.session;
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            password = this.askPassword(this.uri.getUserInfo(), this.uri.getHost());
            this.session.setPassword(password);
            try {
                this.session.connect();
            }
            catch (JSchException e) {
                throw new CoreException(Status.error((String)(String.valueOf(Messages.SSHBase_CreateSessionFailed) + e.getMessage())));
            }
            passwords.put(this.uri.getAuthority(), password);
        }
        return this.session;
    }

    private String askPassword(String user, String host) throws CoreException {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return "";
        }
        SSHPasswordDialog d = new SSHPasswordDialog(w.getShell(), user, host);
        if (d.open() == 0) {
            return d.getPassword();
        }
        throw new CoreException(Status.error((String)Messages.SSHBase_CreateSessionCancelled));
    }

    protected ChannelSftp getChannelSftp() throws CoreException {
        this.loadSession();
        if (this.channelSftp == null || !this.channelSftp.isConnected()) {
            try {
                this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
                this.channelSftp.connect();
            }
            catch (JSchException e) {
                throw new CoreException(Status.error((String)(String.valueOf(Messages.SSHBase_CreateSessionFailed) + e.getMessage()), (Throwable)e));
            }
        }
        return this.channelSftp;
    }

    protected ChannelExec createChannelExec() throws CoreException {
        this.loadSession();
        try {
            return (ChannelExec)this.session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new CoreException(Status.error((String)(String.valueOf(Messages.SSHBase_CreateSessionFailed) + e.getMessage()), (Throwable)e));
        }
    }
}

