/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.ssh.proxy.Activator;
import org.eclipse.linuxtools.internal.ssh.proxy.Messages;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHBase;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHProcess;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;

public class SSHCommandLauncher
extends SSHBase
implements IRemoteCommandLauncher {
    private SSHProcess fProcess;

    public SSHCommandLauncher(URI uri) {
        super(uri);
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitorm, PTY pty) throws CoreException {
        int n;
        StringBuilder cmd = new StringBuilder();
        if (changeToDirectory != null) {
            cmd.append("cd " + changeToDirectory.toString() + "; ");
        }
        cmd.append(commandPath.toString());
        cmd.append(" ");
        if (args != null) {
            String[] stringArray = args;
            n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                cmd.append("\"" + s + "\"");
                cmd.append(" ");
                ++n2;
            }
        }
        try {
            ChannelExec channel = this.createChannelExec();
            if (env != null) {
                String[] stringArray = env;
                int n3 = env.length;
                n = 0;
                while (n < n3) {
                    String s = stringArray[n];
                    String[] tokens = s.split("=", 2);
                    switch (tokens.length) {
                        case 1: {
                            channel.setEnv(tokens[0], null);
                            break;
                        }
                        case 2: {
                            channel.setEnv(tokens[0], tokens[1]);
                            break;
                        }
                        default: {
                            Activator.log(2, String.valueOf(Messages.SSHCommandLauncher_malformed_env_var_string) + s);
                        }
                    }
                    ++n;
                }
            }
            channel.setCommand(cmd.toString());
            channel.connect();
            this.fProcess = new SSHProcess(channel);
            return this.fProcess;
        }
        catch (JSchException e) {
            throw new CoreException(Status.error((String)(String.valueOf(Messages.SSHCommandLauncher_execution_problem) + e.getMessage()), (Throwable)e));
        }
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        if (this.fProcess == null) {
            return -1;
        }
        return this.fProcess.waitAndRead(output, err, monitor);
    }

    public String getErrorMessage() {
        return null;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) throws CoreException {
        return this.execute(commandPath, args, env, changeToDirectory, monitor, null);
    }
}

