/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.piecharts;

import java.util.List;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesData;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.model.IdNodeDataModel;
import org.eclipse.swtchart.model.Node;

public class CircularSeriesData
implements ICircularSeriesData {
    private IdNodeDataModel model;
    private Node rootNode;
    private ICircularSeriesSettings pieSeriesSettings;
    private String nodeClass;
    private String valueClass;

    public CircularSeriesData() {
        this.model = new IdNodeDataModel();
        this.rootNode = this.model.getRootNode();
        this.pieSeriesSettings = new CircularSeriesSettings();
        this.nodeClass = "Node";
        this.valueClass = "Value";
    }

    public CircularSeriesData(ICircularSeriesData pieSeriesData) {
        this.pieSeriesSettings = new CircularSeriesSettings();
        this.pieSeriesSettings.setDescription(pieSeriesData.getTitle());
    }

    @Override
    public String getTitle() {
        return this.model.getId();
    }

    @Override
    public void setSeries(String[] labels, double[] values) {
        int length = labels.length;
        int cfr_ignored_0 = values.length;
        int i = 0;
        while (i != length) {
            new Node(labels[i], values[i], this.rootNode);
            ++i;
        }
        this.model.update();
    }

    @Override
    public List<Node> getSeries() {
        return this.rootNode.getChildren();
    }

    @Override
    public IdNodeDataModel getDataModel() {
        return this.model;
    }

    @Override
    public void setDataModel(IdNodeDataModel data) {
        this.model = data;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Node getNodeById(String id) {
        return this.model.getNodeById(id);
    }

    @Override
    public ICircularSeriesSettings getSettings() {
        return this.pieSeriesSettings;
    }

    @Override
    public void setTitle(String id) {
        this.model.setId(id);
    }

    @Override
    public String getNodeClass() {
        return this.nodeClass;
    }

    @Override
    public void setNodeClass(String nodeClass) {
        this.nodeClass = nodeClass;
    }

    @Override
    public String getValueClass() {
        return this.valueClass;
    }

    @Override
    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
    }
}

