/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultDockerConnectionStorageManager
implements IDockerConnectionStorageManager {
    public static final String CONNECTIONS_FILE_NAME = "dockerconnections.xml";

    @Override
    public List<IDockerConnection> loadConnections() {
        ArrayList<IDockerConnection> connections;
        block10: {
            connections = new ArrayList<IDockerConnection>();
            IPath stateLocation = Activator.getDefault().getStateLocation();
            File connectionFile = stateLocation.append(CONNECTIONS_FILE_NAME).toFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (!connectionFile.exists()) break block10;
                Document d = db.parse(connectionFile);
                Element e = d.getDocumentElement();
                NodeList connectionNodes = e.getElementsByTagName("connection");
                int x = 0;
                while (x < connectionNodes.getLength()) {
                    Node n = connectionNodes.item(x);
                    NamedNodeMap attrs = n.getAttributes();
                    Node nameNode = attrs.getNamedItem("name");
                    Node uriNode = attrs.getNamedItem("uri");
                    Node usernameNode = attrs.getNamedItem("username");
                    Node certNode = attrs.getNamedItem("cert");
                    if (uriNode != null) {
                        String uri = uriNode.getNodeValue();
                        String name = nameNode.getNodeValue();
                        if (usernameNode != null) {
                            String username = usernameNode.getNodeValue();
                            String key = DockerConnection.getPreferencesKey(uri, username);
                            ISecurePreferences root = SecurePreferencesFactory.getDefault();
                            ISecurePreferences node = root.node(key);
                            try {
                                String password = node.get("password", null);
                            }
                            catch (StorageException e1) {
                                e1.printStackTrace();
                            }
                        }
                        DockerConnection.Builder builder = new DockerConnection.Builder().name(name);
                        if (uri.startsWith("unix:")) {
                            builder = builder.unixSocket(uri);
                        } else {
                            builder = builder.tcpHost(uri);
                            if (certNode != null) {
                                builder = builder.tcpCertPath(certNode.getNodeValue());
                            }
                        }
                        DockerConnection connection = builder.build();
                        connections.add(connection);
                    }
                    ++x;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Activator.log(e);
            }
        }
        return connections;
    }

    @Override
    public void saveConnections(List<IDockerConnection> connections) {
        IPath stateLocation = Activator.getDefault().getStateLocation();
        File connectionFile = stateLocation.append(CONNECTIONS_FILE_NAME).toFile();
        try {
            if (!connectionFile.exists()) {
                connectionFile.createNewFile();
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter p = new PrintWriter(new BufferedWriter(new FileWriter(connectionFile)));){
                p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                p.println("<connections>");
                for (IDockerConnection d : connections) {
                    p.print("<connection name=\"" + d.getName() + "\" uri=\"" + d.getUri());
                    if (d.getUsername() != null) {
                        p.print("\" username=\"" + d.getUsername());
                    }
                    if (d.getTcpCertPath() != null) {
                        p.print("\" cert=\"" + d.getTcpCertPath());
                    }
                    p.println("\"/>");
                }
                p.println("</connections>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }
}

