/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;

public class DockerContainerConfig
implements IDockerContainerConfig {
    private final String hostname;
    private final String domainname;
    private final String user;
    private final Long memory;
    private final Long memorySwap;
    private final Long cpuShares;
    private final String cpuset;
    private final boolean attachStdin;
    private final boolean attachStdout;
    private final boolean attachStderr;
    private final List<String> portSpecs;
    private final Set<String> exposedPorts;
    private final boolean tty;
    private final boolean openStdin;
    private final boolean stdinOnce;
    private final List<String> env;
    private final List<String> cmd;
    private final String image;
    private final Set<String> volumes;
    private final String workingDir;
    private final List<String> entrypoint;
    private final boolean networkDisabled;
    private final List<String> onBuild;
    private final Map<String, String> labels;

    public DockerContainerConfig(ContainerConfig containerConfig) {
        this.hostname = containerConfig != null ? containerConfig.hostname() : null;
        this.domainname = containerConfig != null ? containerConfig.domainname() : null;
        this.user = containerConfig != null ? containerConfig.user() : null;
        HostConfig hc = containerConfig != null ? containerConfig.hostConfig() : null;
        this.memory = hc != null ? hc.memory() : null;
        this.memorySwap = hc != null ? hc.memorySwap() : null;
        this.cpuShares = hc != null ? hc.cpuShares() : null;
        this.cpuset = hc != null ? hc.cpusetCpus() : null;
        this.attachStdin = containerConfig != null && containerConfig.attachStdin() != null ? containerConfig.attachStdin() : false;
        this.attachStdout = containerConfig != null && containerConfig.attachStdout() != null ? containerConfig.attachStdout() : false;
        this.attachStderr = containerConfig != null && containerConfig.attachStderr() != null ? containerConfig.attachStderr() : false;
        this.portSpecs = containerConfig != null ? containerConfig.portSpecs() : null;
        this.exposedPorts = containerConfig != null ? containerConfig.exposedPorts() : null;
        this.tty = containerConfig != null && containerConfig.tty() != null ? containerConfig.tty() : false;
        this.openStdin = containerConfig != null && containerConfig.openStdin() != null ? containerConfig.openStdin() : false;
        this.stdinOnce = containerConfig != null && containerConfig.stdinOnce() != null ? containerConfig.stdinOnce() : false;
        this.env = containerConfig != null ? containerConfig.env() : null;
        this.cmd = containerConfig != null ? containerConfig.cmd() : null;
        this.image = containerConfig != null ? containerConfig.image() : null;
        this.volumes = containerConfig != null ? containerConfig.volumes() : null;
        this.workingDir = containerConfig != null ? containerConfig.workingDir() : null;
        this.entrypoint = containerConfig != null ? containerConfig.entrypoint() : null;
        this.networkDisabled = containerConfig != null && containerConfig.networkDisabled() != null ? containerConfig.networkDisabled() : false;
        this.onBuild = containerConfig != null ? containerConfig.onBuild() : null;
        this.labels = containerConfig != null ? containerConfig.labels() : null;
    }

    private DockerContainerConfig(Builder builder) {
        this.hostname = builder.hostname;
        this.domainname = builder.domainname;
        this.user = builder.user;
        this.memory = builder.memory;
        this.memorySwap = builder.memorySwap;
        this.cpuShares = builder.cpuShares;
        this.cpuset = builder.cpuset;
        this.attachStdin = builder.attachStdin != null ? builder.attachStdin : false;
        this.attachStdout = builder.attachStdout != null ? builder.attachStdout : false;
        this.attachStderr = builder.attachStderr != null ? builder.attachStderr : false;
        this.portSpecs = builder.portSpecs;
        this.exposedPorts = builder.exposedPorts;
        this.tty = builder.tty != null ? builder.tty : false;
        this.openStdin = builder.openStdin != null ? builder.openStdin : false;
        this.stdinOnce = builder.stdinOnce != null ? builder.stdinOnce : false;
        this.env = builder.env;
        this.cmd = builder.cmd;
        this.image = builder.image;
        this.volumes = builder.volumes;
        this.workingDir = builder.workingDir;
        this.entrypoint = builder.entrypoint;
        this.networkDisabled = builder.networkDisabled != null ? builder.networkDisabled : false;
        this.onBuild = builder.onBuild;
        this.labels = builder.labels;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public String domainname() {
        return this.domainname;
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    @Deprecated
    public Long memory() {
        return this.memory;
    }

    @Override
    @Deprecated
    public Long memorySwap() {
        return this.memorySwap;
    }

    @Override
    @Deprecated
    public Long cpuShares() {
        return this.cpuShares;
    }

    @Override
    @Deprecated
    public String cpuset() {
        return this.cpuset;
    }

    @Override
    public boolean attachStdin() {
        return this.attachStdin;
    }

    @Override
    public boolean attachStdout() {
        return this.attachStdout;
    }

    @Override
    public boolean attachStderr() {
        return this.attachStderr;
    }

    @Override
    public List<String> portSpecs() {
        if (this.portSpecs == null) {
            return Collections.emptyList();
        }
        return this.portSpecs;
    }

    @Override
    public Set<String> exposedPorts() {
        if (this.exposedPorts == null) {
            return Collections.emptySet();
        }
        return this.exposedPorts;
    }

    @Override
    public boolean tty() {
        return this.tty;
    }

    @Override
    public boolean openStdin() {
        return this.openStdin;
    }

    @Override
    public boolean stdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public List<String> env() {
        if (this.env == null) {
            return Collections.emptyList();
        }
        return this.env;
    }

    @Override
    public List<String> cmd() {
        if (this.cmd == null) {
            return Collections.emptyList();
        }
        return this.cmd;
    }

    @Override
    public String image() {
        return this.image;
    }

    @Override
    public Set<String> volumes() {
        if (this.volumes == null) {
            return Collections.emptySet();
        }
        return this.volumes;
    }

    @Override
    public String workingDir() {
        return this.workingDir;
    }

    @Override
    public List<String> entrypoint() {
        if (this.entrypoint == null) {
            return Collections.emptyList();
        }
        return this.entrypoint;
    }

    @Override
    public boolean networkDisabled() {
        return this.networkDisabled;
    }

    @Override
    public List<String> onBuild() {
        if (this.onBuild == null) {
            return Collections.emptyList();
        }
        return this.onBuild;
    }

    public Map<String, String> labels() {
        if (this.labels == null) {
            return Collections.emptyMap();
        }
        return this.labels;
    }

    /* synthetic */ DockerContainerConfig(Builder builder, DockerContainerConfig dockerContainerConfig) {
        this(builder);
    }

    public static class Builder {
        private String hostname;
        private String domainname;
        private String user;
        private Long memory;
        private Long memorySwap;
        private Long cpuShares;
        private String cpuset;
        private Boolean attachStdin;
        private Boolean attachStdout;
        private Boolean attachStderr;
        private List<String> portSpecs;
        private Set<String> exposedPorts;
        private Boolean tty;
        private Boolean openStdin;
        private Boolean stdinOnce;
        private List<String> env;
        private List<String> cmd;
        private String image;
        private Set<String> volumes;
        private String workingDir;
        private List<String> entrypoint;
        private Boolean networkDisabled;
        private List<String> onBuild;
        private Map<String, String> labels;

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public String hostname() {
            return this.hostname;
        }

        public Builder domainname(String domainname) {
            this.domainname = domainname;
            return this;
        }

        public String domainname() {
            return this.domainname;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public String user() {
            return this.user;
        }

        public Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public Long memory() {
            return this.memory;
        }

        public Builder memorySwap(Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Long memorySwap() {
            return this.memorySwap;
        }

        public Builder cpuShares(Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Long cpuShares() {
            return this.cpuShares;
        }

        public Builder cpuset(String cpuset) {
            this.cpuset = cpuset;
            return this;
        }

        public String cpuset() {
            return this.cpuset;
        }

        public Builder attachStdin(Boolean attachStdin) {
            this.attachStdin = attachStdin;
            return this;
        }

        public Boolean attachStdin() {
            return this.attachStdin;
        }

        public Builder attachStdout(Boolean attachStdout) {
            this.attachStdout = attachStdout;
            return this;
        }

        public Boolean attachStdout() {
            return this.attachStdout;
        }

        public Builder attachStderr(Boolean attachStderr) {
            this.attachStderr = attachStderr;
            return this;
        }

        public Boolean attachStderr() {
            return this.attachStderr;
        }

        public Builder portSpecs(List<String> portSpecs) {
            this.portSpecs = new ArrayList<String>(portSpecs);
            return this;
        }

        public Builder portSpecs(String ... portSpecs) {
            this.portSpecs = Arrays.asList(portSpecs);
            return this;
        }

        public List<String> portSpecs() {
            return this.portSpecs;
        }

        public Builder exposedPorts(Set<String> exposedPorts) {
            this.exposedPorts = new TreeSet<String>(exposedPorts);
            return this;
        }

        public Builder exposedPorts(String ... exposedPorts) {
            this.exposedPorts = new TreeSet<String>(Arrays.asList(exposedPorts));
            return this;
        }

        public Set<String> exposedPorts() {
            return this.exposedPorts;
        }

        public Builder tty(Boolean tty) {
            this.tty = tty;
            return this;
        }

        public Boolean tty() {
            return this.tty;
        }

        public Builder openStdin(Boolean openStdin) {
            this.openStdin = openStdin;
            return this;
        }

        public Boolean openStdin() {
            return this.openStdin;
        }

        public Builder stdinOnce(Boolean stdinOnce) {
            this.stdinOnce = stdinOnce;
            return this;
        }

        public Boolean stdinOnce() {
            return this.stdinOnce;
        }

        public Builder env(List<String> env) {
            this.env = new ArrayList<String>(env);
            return this;
        }

        public Builder env(String ... env) {
            this.env = Arrays.asList(env);
            return this;
        }

        public List<String> env() {
            return this.env;
        }

        public Builder cmd(List<String> cmd) {
            this.cmd = cmd;
            return this;
        }

        public Builder cmd(String ... cmd) {
            return this.cmd(Arrays.asList(cmd));
        }

        public Builder cmd(String cmd) {
            if (cmd != null && !cmd.isEmpty()) {
                return this.cmd(cmd.split(" "));
            }
            return this;
        }

        public List<String> cmd() {
            return this.cmd;
        }

        public Builder image(String image) {
            this.image = image;
            return this;
        }

        public String image() {
            return this.image;
        }

        public Builder volumes(Set<String> volumes) {
            this.volumes = new TreeSet<String>(volumes);
            return this;
        }

        public Builder volumes(String ... volumes) {
            this.volumes = new TreeSet<String>(Arrays.asList(volumes));
            return this;
        }

        public Set<String> volumes() {
            return this.volumes;
        }

        public Builder workingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public String workingDir() {
            return this.workingDir;
        }

        public Builder entryPoint(List<String> entrypoint) {
            if (entrypoint != null && !entrypoint.isEmpty()) {
                this.entrypoint = new ArrayList<String>(entrypoint);
            }
            return this;
        }

        public Builder entryPoint(String ... entrypoint) {
            return this.entryPoint(Arrays.asList(entrypoint));
        }

        public Builder entryPoint(String entrypoint) {
            if (entrypoint != null && !entrypoint.isEmpty()) {
                return this.entryPoint(entrypoint.split(" "));
            }
            this.entrypoint = null;
            return this;
        }

        public List<String> entryPoint() {
            return this.entrypoint;
        }

        public Builder networkDisabled(Boolean networkDisabled) {
            this.networkDisabled = networkDisabled;
            return this;
        }

        public Boolean networkDisabled() {
            return this.networkDisabled;
        }

        public Builder onBuild(List<String> onBuild) {
            this.onBuild = new ArrayList<String>(onBuild);
            return this;
        }

        public Builder onBuild(String ... onBuild) {
            this.onBuild = Arrays.asList(onBuild);
            return this;
        }

        public List<String> onBuild() {
            return this.onBuild;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public DockerContainerConfig build() {
            return new DockerContainerConfig(this, null);
        }
    }
}

