/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.internal.docker.core.Messages;
import org.eclipse.osgi.util.NLS;

public class DockerMachine {
    public static String[] getNames(String pathToDockerMachine) {
        return DockerMachine.execute(pathToDockerMachine, new String[]{"ls", "-q"}, new String[0]);
    }

    public static String getHost(String name, String dockerMachineInstallDir, String vmDriverInstallDir) {
        String[] res = DockerMachine.execute(dockerMachineInstallDir, new String[]{"url", name}, vmDriverInstallDir);
        return res.length == 1 ? res[0] : null;
    }

    public static String getCertPath(String name, String pathToDockerMachine, String vmDriverInstallDir) {
        String[] envVariables;
        String[] stringArray = envVariables = DockerMachine.execute(pathToDockerMachine, new String[]{"env", name}, vmDriverInstallDir);
        int n = envVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String envVariable = stringArray[n2];
            if (envVariable.contains("DOCKER_CERT_PATH")) {
                return envVariable.split("=")[1].replace("\"", "");
            }
            ++n2;
        }
        return null;
    }

    private static String[] execute(String dockerMachineInstallDir, String[] args, String ... extraPaths) {
        try {
            String[] command = new String[args.length + 1];
            command[0] = Paths.get(dockerMachineInstallDir, "docker-machine").toString();
            String envPath = System.getenv("PATH");
            if (envPath != null) {
                String[] stringArray = envPath.split(File.pathSeparator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dir = stringArray[n2];
                    Path dmPath = Paths.get(dir, "docker-machine");
                    if (dmPath.toFile().exists()) {
                        command[0] = dmPath.toString();
                        break;
                    }
                    ++n2;
                }
            }
            System.arraycopy(args, 0, command, 1, args.length);
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Map<String, String> environment = processBuilder.environment();
            StringBuilder path = new StringBuilder();
            String[] stringArray = extraPaths;
            int n = extraPaths.length;
            int dmPath = 0;
            while (dmPath < n) {
                String extraPath = stringArray[dmPath];
                path.append(File.pathSeparator).append(extraPath);
                ++dmPath;
            }
            String newEnvPath = String.valueOf(environment.get("PATH")) + path.toString();
            environment.put("PATH", newEnvPath);
            boolean dockerMachineCommandExists = DockerMachine.checkPathToDockerMachine(newEnvPath);
            if (!dockerMachineCommandExists) {
                Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.core", NLS.bind((String)Messages.Docker_Machine_Command_Not_Found, (Object)newEnvPath)));
                return new String[0];
            }
            Process p = processBuilder.start();
            p.waitFor();
            if (p.exitValue() == 0) {
                ArrayList<String> result = new ArrayList<String>();
                Throwable throwable = null;
                Object var13_21 = null;
                try (BufferedReader buff = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = buff.readLine()) != null) {
                        result.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return result.toArray(new String[0]);
            }
            StringBuffer errorMessage = new StringBuffer();
            Throwable throwable = null;
            Object var13_23 = null;
            try (BufferedReader buff = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String line;
                while ((line = buff.readLine()) != null) {
                    errorMessage.append(line).append('\n');
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", errorMessage.toString()));
        }
        catch (IOException | InterruptedException e) {
            Activator.log(e);
        }
        return new String[0];
    }

    public static boolean checkPathToDockerMachine(String path) {
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathFragment = stringArray[n2];
            File pathToDockerMachine = new File(pathFragment, "docker-machine");
            if (pathToDockerMachine.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

