/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.ConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class RunConsole
extends IOConsole {
    public static final String ID = "containerLog";
    public static final String CONTAINER_LOG_TITLE = "ContainerLog.title";
    public static final String DEFAULT_ID = "__DEFAULT_ID__";
    private String containerId;
    private String id;
    private OutputStream outputStream;
    private boolean attached = false;

    public static RunConsole findConsole(String containerId) {
        if (containerId == null) {
            return null;
        }
        return RunConsole.findConsole(containerId, DEFAULT_ID);
    }

    public static RunConsole findConsole(IDockerContainer container) {
        if (container == null) {
            return null;
        }
        return RunConsole.findConsole(container.id(), DEFAULT_ID, container.name());
    }

    public static RunConsole findConsole(String containerId, String id) {
        return RunConsole.findConsole(containerId, id, containerId.substring(0, 8));
    }

    public static RunConsole findConsole(String containerId, String id, String name) {
        RunConsole ret = null;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole cons = iConsoleArray[n2];
            if (cons instanceof RunConsole && ((RunConsole)cons).containerId.equals(containerId) && ((RunConsole)cons).id.equals(id)) {
                ret = (RunConsole)cons;
            }
            ++n2;
        }
        if (ret == null) {
            ret = new RunConsole(containerId, id, name);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{ret});
        }
        return ret;
    }

    public void setTitle(String name) {
        this.setName(name);
    }

    public void attachToConsole(final IDockerConnection connection) {
        IOConsoleInputStream in = this.getInputStream();
        IOConsoleOutputStream out = this.newOutputStream();
        Thread t = new Thread(new Runnable((InputStream)in, (OutputStream)out){
            private final /* synthetic */ InputStream val$in;
            private final /* synthetic */ OutputStream val$out;
            {
                this.val$in = inputStream;
                this.val$out = outputStream;
            }

            @Override
            public void run() {
                try {
                    DockerConnection conn = (DockerConnection)connection;
                    if (conn.getContainerInfo(RunConsole.this.containerId).config().openStdin()) {
                        while (!conn.getContainerInfo(RunConsole.this.containerId).state().running().booleanValue()) {
                            Thread.sleep(1000L);
                        }
                        conn.attachCommand(RunConsole.this.containerId, this.val$in, this.val$out);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
        this.attached = true;
    }

    public static void attachToTerminal(final IDockerConnection connection, final String containerId) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DockerConnection conn = (DockerConnection)connection;
                    if (conn.getContainerInfo(containerId).config().openStdin()) {
                        while (!conn.getContainerInfo(containerId).state().running().booleanValue()) {
                            Thread.sleep(1000L);
                        }
                        conn.attachCommand(containerId, null, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    public void attachToConsole(IDockerConnection connection, String containerId) {
        this.containerId = containerId;
        this.attachToConsole(connection);
    }

    public boolean isAttached() {
        return this.attached;
    }

    public static void removeConsole(RunConsole console) {
        console.closeOutputStream();
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
    }

    public void showConsole() {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
    }

    public void closeOutputStream() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream getOutputStream() {
        this.outputStream = new ConsoleOutputStream((OutputStream)this.newOutputStream());
        return this.outputStream;
    }

    private RunConsole(String containerId, String id, String name) {
        super(DVMessages.getFormattedString(CONTAINER_LOG_TITLE, name), ID, null, true);
        this.containerId = containerId;
        this.id = id;
    }
}

