/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.commands.RunImageCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.ImagePushProgressHandler;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePush;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class PushImageCommandHandler
extends AbstractHandler {
    private static final String PUSH_IMAGE_JOB_TITLE = "ImagePush.title";
    private static final String PUSH_IMAGE_JOB_TASK = "ImagePush.msg";
    private static final String ERROR_PUSHING_IMAGE = "ImagePushError.msg";
    private static final String NO_CONNECTION = "NoConnection.error";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerImage selectedImage = RunImageCommandHandler.getSelectedImage(activePart);
        ImagePush wizard = new ImagePush(selectedImage);
        boolean pushImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (pushImage) {
            IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
            this.performPushImage(wizard, connection);
        }
        return null;
    }

    private void performPushImage(final ImagePush wizard, final IDockerConnection connection) {
        if (connection == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)DVMessages.getFormattedString(PushImageCommandHandler.NO_CONNECTION, new String[0]));
                }
            });
            return;
        }
        Job pushImageJob = new Job(DVMessages.getFormattedString(PUSH_IMAGE_JOB_TITLE, wizard.getImageTag())){

            protected IStatus run(IProgressMonitor monitor) {
                final String tag = wizard.getImageTag();
                monitor.beginTask(DVMessages.getString(PushImageCommandHandler.PUSH_IMAGE_JOB_TASK), -1);
                try {
                    try {
                        ((DockerConnection)connection).pushImage(tag, (IDockerProgressHandler)new ImagePushProgressHandler(connection, tag));
                    }
                    catch (DockerException e) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(PushImageCommandHandler.ERROR_PUSHING_IMAGE, tag), (String)e.getMessage());
                            }
                        });
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        pushImageJob.schedule();
    }
}

