/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRun;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunImageCommandHandler
extends AbstractHandler {
    private static final String ERROR_CREATING_CONTAINER = "ContainerCreateError.msg";
    private static final String ERROR_REMOVING_CONTAINER = "ContainerRemoveError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerImage selectedImage = RunImageCommandHandler.getSelectedImage(activePart);
        if (selectedImage == null) {
            Activator.logErrorMessage(DVMessages.getString("RunImageUnableToRetrieveError.msg"));
        } else {
            try {
                ImageRun wizard = new ImageRun(selectedImage);
                boolean runImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
                if (runImage) {
                    DockerContainerConfig containerConfig = wizard.getDockerContainerConfig();
                    IDockerHostConfig hostConfig = wizard.getDockerHostConfig();
                    RunImageCommandHandler.runImage(selectedImage, (IDockerContainerConfig)containerConfig, hostConfig, wizard.getDockerContainerName(), wizard.removeWhenExits());
                }
            }
            catch (CoreException | DockerException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    public static void runImage(final IDockerImage image, final IDockerContainerConfig containerConfig, final IDockerHostConfig hostConfig, final String containerName, final boolean removeWhenExits) {
        final IDockerConnection connection = image.getConnection();
        if (containerConfig.tty()) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
            }
            catch (PartInitException e) {
                Activator.log(e);
            }
        }
        Job runImageJob = new Job(DVMessages.getString("RunImageCreateContainer.job")){

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                block41: {
                    String containerId;
                    block38: {
                        Throwable throwable3222222222;
                        block40: {
                            block39: {
                                IDockerContainer container;
                                block36: {
                                    IStatus iStatus;
                                    block37: {
                                        monitor.beginTask(DVMessages.getString("RunImageRunningTask.msg"), 2);
                                        containerId = null;
                                        SubProgressMonitor createContainerMonitor = new SubProgressMonitor(monitor, 1);
                                        createContainerMonitor.beginTask(DVMessages.getString("RunImageCreatingContainerTask.msg"), 1);
                                        containerId = ((DockerConnection)connection).createContainer(containerConfig, hostConfig, containerName);
                                        container = ((DockerConnection)connection).getContainer(containerId);
                                        createContainerMonitor.done();
                                        if (!monitor.isCanceled()) break block36;
                                        iStatus = Status.CANCEL_STATUS;
                                        if (!removeWhenExits) break block37;
                                        try {
                                            if (containerId != null) {
                                                ((DockerConnection)connection).waitForContainer(containerId);
                                                ((DockerConnection)connection).stopLoggingThread(containerId);
                                                while (((DockerConnection)connection).loggingStatus(containerId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                                                    Thread.sleep(1000L);
                                                }
                                            }
                                        }
                                        catch (InterruptedException | DockerException throwable2) {
                                            // empty catch block
                                        }
                                        try {
                                            if (containerId != null) {
                                                ((DockerConnection)connection).removeContainer(containerId);
                                            }
                                        }
                                        catch (InterruptedException | DockerException e2) {
                                            String id = containerId;
                                            Display.getDefault().syncExec(new Runnable(id, (Exception)e2){
                                                private final /* synthetic */ String val$id;
                                                private final /* synthetic */ Exception val$e;
                                                {
                                                    this.val$id = string;
                                                    this.val$e = exception;
                                                }

                                                @Override
                                                public void run() {
                                                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_REMOVING_CONTAINER, this.val$id), (String)this.val$e.getMessage());
                                                }
                                            });
                                        }
                                    }
                                    monitor.done();
                                    return iStatus;
                                }
                                try {
                                    SubProgressMonitor startContainerMonitor = new SubProgressMonitor(monitor, 1);
                                    startContainerMonitor.beginTask(DVMessages.getString("RunImageStartingContainerTask.msg"), 1);
                                    RunConsole console = CommandUtils.getRunConsole(connection, container);
                                    if (console != null) {
                                        console.showConsole();
                                        ((DockerConnection)connection).startContainer(containerId, console.getOutputStream());
                                    } else {
                                        ((DockerConnection)connection).startContainer(containerId, null);
                                    }
                                    startContainerMonitor.done();
                                    LaunchConfigurationUtils.createLaunchConfiguration(image, containerConfig, hostConfig, containerName, removeWhenExits);
                                    break block38;
                                }
                                catch (InterruptedException | DockerException e) {
                                    Display.getDefault().syncExec(new Runnable((Exception)e){
                                        private final /* synthetic */ Exception val$e;
                                        {
                                            this.val$e = exception;
                                        }

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_CREATING_CONTAINER, containerConfig.image()), (String)this.val$e.getMessage());
                                        }
                                    });
                                    if (!removeWhenExits) break block39;
                                    try {
                                        if (containerId != null) {
                                            ((DockerConnection)connection).waitForContainer(containerId);
                                            ((DockerConnection)connection).stopLoggingThread(containerId);
                                            while (((DockerConnection)connection).loggingStatus(containerId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                                                Thread.sleep(1000L);
                                            }
                                        }
                                    }
                                    catch (InterruptedException | DockerException e2) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    if (containerId != null) {
                                        ((DockerConnection)connection).removeContainer(containerId);
                                    }
                                }
                                catch (InterruptedException | DockerException e) {
                                    String id = containerId;
                                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            monitor.done();
                            break block41;
                            catch (Throwable throwable3222222222) {
                                if (!removeWhenExits) break block40;
                                try {
                                    if (containerId != null) {
                                        ((DockerConnection)connection).waitForContainer(containerId);
                                        ((DockerConnection)connection).stopLoggingThread(containerId);
                                        while (((DockerConnection)connection).loggingStatus(containerId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                                            Thread.sleep(1000L);
                                        }
                                    }
                                }
                                catch (InterruptedException | DockerException e) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (containerId != null) {
                                    ((DockerConnection)connection).removeContainer(containerId);
                                }
                            }
                            catch (InterruptedException | DockerException e) {
                                String id = containerId;
                                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        monitor.done();
                        throw throwable3222222222;
                    }
                    if (removeWhenExits) {
                        try {
                            if (containerId != null) {
                                ((DockerConnection)connection).waitForContainer(containerId);
                                ((DockerConnection)connection).stopLoggingThread(containerId);
                                while (((DockerConnection)connection).loggingStatus(containerId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                                    Thread.sleep(1000L);
                                }
                            }
                        }
                        catch (InterruptedException | DockerException e) {
                            // empty catch block
                        }
                        try {
                            if (containerId != null) {
                                ((DockerConnection)connection).removeContainer(containerId);
                            }
                        }
                        catch (InterruptedException | DockerException e) {
                            String id = containerId;
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        runImageJob.schedule();
    }

    public static IDockerImage getSelectedImage(IWorkbenchPart activePart) {
        IStructuredSelection selection;
        if (activePart instanceof DockerExplorerView) {
            ITreeSelection selection2 = (ITreeSelection)((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return (IDockerImage)selection2.getFirstElement();
        }
        if (activePart instanceof DockerImagesView && !(selection = (IStructuredSelection)((DockerImagesView)activePart).getSelection()).isEmpty()) {
            return (IDockerImage)selection.getFirstElement();
        }
        return null;
    }
}

