/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseContainersCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class StartContainersCommandHandler
extends BaseContainersCommandHandler {
    private static final String CONTAINERS_START_MSG = "ContainersStart.msg";
    private static final String CONTAINER_START_MSG = "ContainerStart.msg";
    private static final String CONTAINER_START_ERROR_MSG = "ContainerStartError.msg";

    @Override
    void executeInJob(IDockerContainer container, IDockerConnection connection) {
        try {
            RunConsole console = CommandUtils.getRunConsole(connection, container);
            if (console != null) {
                console.showConsole();
                ((DockerConnection)connection).startContainer(container.id(), console.getOutputStream());
            } else {
                ((DockerConnection)connection).startContainer(container.id(), null);
            }
            ((DockerConnection)connection).getContainers(true);
        }
        catch (InterruptedException | DockerException e) {
            String errorMessage = DVMessages.getFormattedString(CONTAINER_START_ERROR_MSG, container.id());
            this.openError(errorMessage, (Exception)e);
        }
    }

    @Override
    String getJobName(List<IDockerContainer> selectedContainers) {
        return DVMessages.getString(CONTAINERS_START_MSG);
    }

    @Override
    String getTaskName(IDockerContainer container) {
        return DVMessages.getFormattedString(CONTAINER_START_MSG, container.name());
    }
}

