/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class LaunchConfigurationUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

    private LaunchConfigurationUtils() {
    }

    public static ILaunchConfigurationType getLaunchConfigType(String configType) {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(configType);
    }

    public static ILaunchConfiguration createLaunchConfiguration(IDockerImage image, IDockerContainerConfig containerConfig, IDockerHostConfig hostConfig, String containerName, boolean removeWhenExits) {
        try {
            DataVolumeModel volume;
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType");
            String imageName = (String)image.repoTags().get(0);
            ILaunchConfigurationWorkingCopy workingCopy = LaunchConfigurationUtils.getLaunchConfigurationworkingCopy(type, imageName);
            workingCopy.setAttribute("creationDate", DATE_FORMAT.format(new Date()));
            workingCopy.setAttribute("connectionName", image.getConnection().getName());
            workingCopy.setAttribute("imageId", image.id());
            workingCopy.setAttribute("imageName", (String)image.repoTags().get(0));
            if (containerName != null && !containerName.isEmpty()) {
                workingCopy.setAttribute("containerName", containerName);
            }
            workingCopy.setAttribute("command", LaunchConfigurationUtils.toString(containerConfig.cmd()));
            workingCopy.setAttribute("entryPoint", LaunchConfigurationUtils.toString(containerConfig.entrypoint()));
            workingCopy.setAttribute("publishAllPorts", hostConfig.publishAllPorts());
            if (hostConfig.publishAllPorts()) {
                IDockerImageInfo imageInfo = image.getConnection().getImageInfo(image.id());
                if (imageInfo != null) {
                    workingCopy.setAttribute("publishedPorts", LaunchConfigurationUtils.serializePortBindings(imageInfo.containerConfig().exposedPorts()));
                }
            } else {
                workingCopy.setAttribute("publishedPorts", LaunchConfigurationUtils.serializePortBindings(hostConfig.portBindings()));
            }
            workingCopy.setAttribute("links", hostConfig.links());
            workingCopy.setAttribute("envVariables", containerConfig.env());
            ArrayList<String> volumes = new ArrayList<String>();
            for (String volumeFrom : hostConfig.volumesFrom()) {
                volume = DataVolumeModel.parseVolumeFrom(volumeFrom);
                if (volume == null) continue;
                volumes.add(volume.toString());
            }
            for (String bind : hostConfig.binds()) {
                volume = DataVolumeModel.parseHostBinding(bind);
                if (volume == null) continue;
                volumes.add(volume.toString());
            }
            workingCopy.setAttribute("volumes", volumes);
            workingCopy.setAttribute("autoRemove", removeWhenExits);
            workingCopy.setAttribute("allocatePseudoTTY", containerConfig.tty());
            workingCopy.setAttribute("interactive", containerConfig.openStdin());
            if (containerConfig.memory() != null) {
                workingCopy.setAttribute("enableLimits", true);
                workingCopy.setAttribute("memoryLimit", Long.toString(containerConfig.memory() / 0x100000L));
            }
            if (containerConfig.cpuShares() != null) {
                workingCopy.setAttribute("enableLimits", true);
                workingCopy.setAttribute("cpuPriority", containerConfig.cpuShares().toString());
            }
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", LaunchMessages.getString("RunDockerImageLaunchConfiguration.creation.failure"), (Throwable)e));
            return null;
        }
    }

    private static String toString(List<String> input) {
        StringBuilder command = new StringBuilder();
        Iterator<String> iterator = input.iterator();
        while (iterator.hasNext()) {
            String fragment = iterator.next();
            command.append(fragment);
            if (!iterator.hasNext()) continue;
            command.append(" ");
        }
        return command.toString();
    }

    public static List<String> serializePortBindings(Map<String, List<IDockerPortBinding>> bindings) {
        ArrayList<String> serializedBindings = new ArrayList<String>();
        if (bindings != null) {
            for (Map.Entry<String, List<IDockerPortBinding>> entry : bindings.entrySet()) {
                for (IDockerPortBinding portBinding : entry.getValue()) {
                    StringBuilder portBindingBuilder = new StringBuilder();
                    portBindingBuilder.append(entry.getKey());
                    portBindingBuilder.append(':');
                    if (portBinding.hostIp() != null) {
                        portBindingBuilder.append(portBinding.hostIp());
                    }
                    portBindingBuilder.append(':');
                    portBindingBuilder.append(portBinding.hostPort());
                    serializedBindings.add(portBindingBuilder.toString());
                }
            }
        }
        return serializedBindings;
    }

    public static List<String> serializePortBindings(Set<String> bindings) {
        ArrayList<String> serializedBindings = new ArrayList<String>();
        if (bindings != null) {
            for (String portBinding : bindings) {
                StringBuilder portBindingBuilder = new StringBuilder();
                portBindingBuilder.append(portBinding);
                portBindingBuilder.append(':');
                portBindingBuilder.append(':');
                String[] containerPort = portBinding.split("/");
                portBindingBuilder.append(containerPort[0]);
                serializedBindings.add(portBindingBuilder.toString());
            }
        }
        return serializedBindings;
    }

    public static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static ILaunchConfiguration getLaunchConfigurationByImageName(ILaunchConfigurationType type, String imageName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration lastLaunchConfiguration = null;
        String lastCreationDate = "";
        ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            String launchConfigImageName = launchConfiguration.getAttribute("imageName", "");
            String launchConfigCreationDate = launchConfiguration.getAttribute("creationDate", "");
            if (launchConfigImageName.equals(imageName) && launchConfigCreationDate.compareTo(lastCreationDate) > 0) {
                lastCreationDate = launchConfigCreationDate;
                lastLaunchConfiguration = launchConfiguration;
            }
            ++n2;
        }
        return lastLaunchConfiguration;
    }

    private static ILaunchConfigurationWorkingCopy getLaunchConfigurationworkingCopy(ILaunchConfigurationType type, String imageName) throws CoreException {
        ILaunchConfiguration existingLaunchConfiguration = LaunchConfigurationUtils.getLaunchConfigurationByImageName(type, imageName);
        if (existingLaunchConfiguration != null) {
            return existingLaunchConfiguration.getWorkingCopy();
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        String configurationName = manager.generateLaunchConfigurationName(imageName);
        return type.newInstance(null, configurationName);
    }

    public static ILaunchConfiguration getLaunchConfigurationByName(ILaunchConfigurationType type, String name) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            String launchConfigName = launchConfiguration.getName();
            if (launchConfigName.equals(name)) {
                return launchConfiguration;
            }
            ++n2;
        }
        return null;
    }

    public static String convertToUnixPath(String path) {
        return LaunchConfigurationUtils.convertToUnixPath(Platform.getOS(), path);
    }

    public static String convertToUnixPath(String os, String path) {
        Matcher m;
        if (os != null && os.equals("win32") && (m = Pattern.compile("([a-zA-Z]):/").matcher(path.replaceAll("\\\\", "/"))).find()) {
            StringBuffer b = new StringBuffer();
            b.append('/');
            m.appendReplacement(b, m.group(1).toLowerCase());
            b.append('/');
            m.appendTail(b);
            return b.toString();
        }
        return path;
    }

    public static String convertToWin32Path(String path) {
        return LaunchConfigurationUtils.convertToWin32Path(Platform.getOS(), path);
    }

    public static String convertToWin32Path(String os, String path) {
        Matcher m;
        if (os != null && os.equals("win32") && (m = Pattern.compile("^/([a-zA-Z])/").matcher(path)).find()) {
            StringBuffer b = new StringBuffer();
            m.appendReplacement(b, m.group(1).toUpperCase());
            b.append(":\\");
            m.appendTail(b);
            return b.toString().replace('/', '\\');
        }
        return path;
    }
}

