/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageEnvironmentTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageLinksTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageMainTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImagePortsTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageResourcesTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageVolumesTab;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;

public class RunImageLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private ImageRunSelectionModel runSelectionModel;
    private ImageRunResourceVolumesVariablesModel runVolumesModel;

    public ImageRunSelectionModel getRunSelectionModel() {
        return this.runSelectionModel;
    }

    public ImageRunResourceVolumesVariablesModel getRunVolumesModel() {
        return this.runVolumesModel;
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        IDockerConnection[] connections = DockerConnectionManager.getInstance().getConnections();
        this.runSelectionModel = null;
        this.runVolumesModel = null;
        if (connections != null && connections.length > 0) {
            this.runSelectionModel = new ImageRunSelectionModel(connections[0]);
            try {
                this.runVolumesModel = new ImageRunResourceVolumesVariablesModel(connections[0]);
            }
            catch (DockerException dockerException) {
                // empty catch block
            }
        }
        this.setTabs((ILaunchConfigurationTab[])new AbstractLaunchConfigurationTab[]{new RunImageMainTab(this.runSelectionModel, this.runVolumesModel), new RunImageVolumesTab(this.runVolumesModel), new RunImagePortsTab(this.runSelectionModel), new RunImageLinksTab(this.runSelectionModel), new RunImageEnvironmentTab(this.runVolumesModel), new RunImageResourcesTab(this.runVolumesModel)});
    }
}

