/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerDataVolumeDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RunImageVolumesTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunVolumesTab.name";
    private static final int COLUMNS = 3;
    private final DataBindingContext dbc = new DataBindingContext();
    private ImageRunResourceVolumesVariablesModel model = null;

    public RunImageVolumesTab(ImageRunResourceVolumesVariablesModel model) {
        this.model = model;
    }

    public ImageRunResourceVolumesVariablesModel getModel() {
        return this.model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
        } else {
            this.setErrorMessage(null);
            this.createVolumeSettingsContainer(container);
        }
        this.setControl((Control)container);
    }

    private void createVolumeSettingsContainer(Composite container) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)new Label(container, 0));
        Label volumesLabel = new Label(container, 0);
        volumesLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.dataVolumesLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)volumesLabel);
        CheckboxTableViewer dataVolumesTableViewer = this.createVolumesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(200, 100).applyTo((Control)dataVolumesTableViewer.getTable());
        this.bind((StructuredViewer)dataVolumesTableViewer, (IObservableList)this.model.getDataVolumes(), BeanProperties.values(DataVolumeModel.class, (String[])new String[]{"containerPath", "mount", "readOnly"}));
        IObservableSet selectedVolumesObservable = BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model);
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)dataVolumesTableViewer, DataVolumeModel.class), selectedVolumesObservable);
        dataVolumesTableViewer.addCheckStateListener(this.onCheckStateChanged());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.addSelectionListener(this.onAddDataVolume(dataVolumesTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.addSelectionListener(this.onEditDataVolume(dataVolumesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveDataVolumes((TableViewer)dataVolumesTableViewer));
        removeButton.setEnabled(false);
        dataVolumesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private ICheckStateListener onCheckStateChanged() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                DataVolumeModel element = (DataVolumeModel)e.getElement();
                if (e.getChecked()) {
                    RunImageVolumesTab.this.model.getSelectedDataVolumes().add(element);
                    element.setSelected(true);
                } else {
                    RunImageVolumesTab.this.model.getSelectedDataVolumes().remove(element);
                    element.setSelected(false);
                }
                RunImageVolumesTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    private void bind(StructuredViewer viewer, IObservableList input, IBeanValueProperty[] labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new DataVolumesLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput((Object)input);
        }
    }

    private ISelectionChangedListener onSelectionChanged(final Button ... targetButtons) {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection().isEmpty()) {
                    RunImageVolumesTab.setControlsEnabled((Control[])targetButtons, false);
                    RunImageVolumesTab.this.updateLaunchConfigurationDialog();
                } else {
                    RunImageVolumesTab.setControlsEnabled((Control[])targetButtons, true);
                    RunImageVolumesTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
    }

    private SelectionListener onAddDataVolume(final CheckboxTableViewer dataVolumesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(RunImageVolumesTab.this.getShell(), RunImageVolumesTab.this.model.getConnection());
                dialog.create();
                if (dialog.open() == 0) {
                    RunImageVolumesTab.this.model.getDataVolumes().add((Object)dialog.getDataVolume());
                    RunImageVolumesTab.this.model.getSelectedDataVolumes().add(dialog.getDataVolume());
                    dialog.getDataVolume().setSelected(true);
                    dataVolumesTableViewer.setChecked((Object)dialog.getDataVolume(), true);
                    RunImageVolumesTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
    }

    private SelectionListener onEditDataVolume(final CheckboxTableViewer dataVolumesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)dataVolumesTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                DataVolumeModel selectedDataVolume = (DataVolumeModel)selection.getFirstElement();
                ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(RunImageVolumesTab.this.getShell(), RunImageVolumesTab.this.model.getConnection(), selectedDataVolume);
                dialog.create();
                if (dialog.open() == 0) {
                    DataVolumeModel dialogDataVolume = dialog.getDataVolume();
                    selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                    selectedDataVolume.setMountType(dialogDataVolume.getMountType());
                    selectedDataVolume.setHostPathMount(dialogDataVolume.getHostPathMount());
                    selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                    selectedDataVolume.setReadOnly(dialogDataVolume.isReadOnly());
                    RunImageVolumesTab.this.model.getSelectedDataVolumes().add(selectedDataVolume);
                    dataVolumesTableViewer.setChecked((Object)selectedDataVolume, true);
                    RunImageVolumesTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
    }

    private SelectionListener onRemoveDataVolumes(final TableViewer dataVolumesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = dataVolumesTableViewer.getStructuredSelection();
                for (DataVolumeModel volume : selection) {
                    RunImageVolumesTab.this.model.removeDataVolume(volume);
                    RunImageVolumesTab.this.model.getSelectedDataVolumes().remove(volume);
                }
                RunImageVolumesTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    private CheckboxTableViewer createVolumesTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.containerPathColumn"), 150);
        this.addTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.mountColumn"), 150);
        this.addTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.readonlyColumn"), 60);
        return tableViewer;
    }

    private TableViewerColumn addTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.container_volume.png");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        ArrayList<DataVolumeModel> volumes = new ArrayList<DataVolumeModel>();
        try {
            List volumesList = configuration.getAttribute("volumes", new ArrayList());
            HashSet<DataVolumeModel> selectedVolumes = new HashSet<DataVolumeModel>();
            for (String volume : volumesList) {
                DataVolumeModel volumeModel = DataVolumeModel.parseString(volume);
                volumes.add(volumeModel);
                if (!volumeModel.getSelected()) continue;
                selectedVolumes.add(volumeModel);
            }
            this.model.setDataVolumes(volumes);
            this.model.setSelectedDataVolumes(selectedVolumes);
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("RunDockerImageLaunchConfiguration.load.failure"), e);
        }
        this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        WritableList volumes = this.model.getDataVolumes();
        Set<DataVolumeModel> selectedVolumes = this.model.getSelectedDataVolumes();
        ArrayList<String> binds = new ArrayList<String>();
        ArrayList<String> volumesFrom = new ArrayList<String>();
        ArrayList<String> volumesList = new ArrayList<String>();
        TreeSet<String> selectedVolumesSet = new TreeSet<String>();
        for (DataVolumeModel volume : volumes) {
            StringBuffer buffer = new StringBuffer();
            volumesList.add(volume.toString());
            switch (volume.getMountType()) {
                case HOST_FILE_SYSTEM: {
                    buffer.append(String.valueOf(volume.getHostPathMount()) + "," + volume.getHostPathMount() + "," + volume.isReadOnly());
                    if (!selectedVolumes.contains(volume)) break;
                    selectedVolumesSet.add(volume.toString());
                    String bind = String.valueOf(this.convertToUnixPath(volume.getHostPathMount())) + ':' + volume.getContainerPath() + ':' + 'Z';
                    if (volume.isReadOnly()) {
                        bind = String.valueOf(bind) + ",ro";
                    }
                    binds.add(bind);
                    break;
                }
                case CONTAINER: {
                    if (!selectedVolumes.contains(volume)) break;
                    selectedVolumesSet.add(volume.toString());
                    volumesFrom.add(volume.getContainerMount());
                    break;
                }
            }
        }
        configuration.setAttribute("binds", binds);
        configuration.setAttribute("volumesFrom", volumesFrom);
        configuration.setAttribute("volumes", volumesList);
    }

    private String convertToUnixPath(String path) {
        String unixPath = path;
        if ("win32".equals(Platform.getOS())) {
            unixPath = unixPath.replaceAll("\\\\", "/");
            Matcher m = Pattern.compile("([a-zA-Z]):/").matcher(unixPath);
            if (m.find()) {
                StringBuffer b = new StringBuffer();
                b.append('/');
                m.appendReplacement(b, m.group(1).toLowerCase());
                b.append('/');
                m.appendTail(b);
                unixPath = b.toString();
            }
        }
        return unixPath;
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    private static final class DataVolumesLabelProvider
    extends ObservableMapLabelProvider {
        public DataVolumesLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            if (dataVolume.getMountType() != null && columnIndex == 1) {
                switch (dataVolume.getMountType()) {
                    case CONTAINER: {
                        return SWTImagesFactory.DESC_CONTAINER.createImage();
                    }
                    case HOST_FILE_SYSTEM: {
                        File hostFile = new File(dataVolume.getMount());
                        if (!hostFile.exists() || hostFile.isDirectory()) {
                            return SWTImagesFactory.DESC_FOLDER_CLOSED.createImage();
                        }
                        return SWTImagesFactory.DESC_FILE.createImage();
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            switch (columnIndex) {
                case 0: {
                    return dataVolume.getContainerPath();
                }
                case 1: {
                    return dataVolume.getMount();
                }
                case 2: {
                    if (dataVolume.getMountType() != ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM) {
                        return null;
                    }
                    if (dataVolume.isReadOnly()) {
                        return WizardMessages.getString("ImageRunResourceVolVarPage.true");
                    }
                    return WizardMessages.getString("ImageRunResourceVolVarPage.false");
                }
            }
            return null;
        }
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImageVolumesTab.this.updateLaunchConfigurationDialog();
        }
    }
}

