/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.validators;

import java.util.regex.Matcher;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImageNameValidator
implements IValidator {
    public IStatus validate(Object value) {
        String imageName = (String)value;
        if (imageName.isEmpty()) {
            return ValidationStatus.cancel((String)WizardMessages.getString("ImagePull.desc"));
        }
        Matcher matcher = DockerImage.imageNamePattern.matcher(imageName);
        if (!matcher.matches()) {
            return ValidationStatus.warning((String)WizardMessages.getString("ImagePull.name.invalidformat.msg"));
        }
        if (matcher.group("tag") == null) {
            return ValidationStatus.warning((String)WizardMessages.getString("ImagePull.assumeLatest.msg"));
        }
        return Status.OK_STATUS;
    }
}

