/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelUtils;

public class ContainerInfoContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IDockerContainer) {
            IDockerContainer container = (IDockerContainer)inputElement;
            return new Object[]{new Object[]{"Id", container.id().substring(0, 12)}, new Object[]{"Image", container.image()}, new Object[]{"Command", container.command()}, new Object[]{"Created", LabelUtils.toCreatedDate(container.created())}, new Object[]{"Status", container.status()}, new Object[]{"Ports", this.getPorts(container)}, new Object[]{"Names", this.getNames(container)}};
        }
        return EMPTY;
    }

    private Object getPorts(IDockerContainer container) {
        if (container.ports().isEmpty()) {
            return "";
        }
        if (container.ports().size() == 1) {
            return LabelUtils.containerPortMappingToString((IDockerPortMapping)container.ports().get(0));
        }
        ArrayList<String> ports = new ArrayList<String>();
        for (IDockerPortMapping portMapping : container.ports()) {
            ports.add(LabelUtils.containerPortMappingToString(portMapping));
        }
        return ports;
    }

    private Object getNames(IDockerContainer container) {
        if (container.names().isEmpty()) {
            return "";
        }
        if (container.names().size() == 1) {
            return container.name();
        }
        return container.names();
    }

    public Object[] getChildren(Object parentElement) {
        Object propertyValue = ((Object[])parentElement)[1];
        Object value = ((Object[])parentElement)[1];
        if (value instanceof List) {
            List propertyValues = (List)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            int i = 0;
            while (i < propertyValues.size()) {
                result[i] = new Object[]{"", LabelUtils.toString(propertyValues.get(i))};
                ++i;
            }
            return result;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Object[]) {
            return !(((Object[])element)[1] instanceof String);
        }
        return false;
    }
}

