/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImagePullFailedException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressDetail;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.ProgressJob;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class ImagePullProgressHandler
implements IDockerProgressHandler {
    private static final String IMAGE_DOWNLOAD_COMPLETE = "ImageDownloadComplete.msg";
    private static final String IMAGE_DOWNLOADING_JOBNAME = "ImageDownloadingJobName.msg";
    private static final String IMAGE_DOWNLOADING_IMAGE = "ImageDownloadingImage.msg";
    private static final String IMAGE_DOWNLOADING = "ImageDownloading.msg";
    private static final String IMAGE_PULLING = "ImagePulling.msg";
    private static final String IMAGE_PULL_COMPLETE = "ImagePullComplete.msg";
    private static final String IMAGE_DOWNLOADING_ALREADY_EXISTS = "ImageDownloadingAlreadyExists.msg";
    private static final String IMAGE_DOWNLOADING_VERIFIED = "ImageDownloadingVerified.msg";
    private String image;
    private DockerConnection connection;
    private Map<String, ProgressJob> progressJobs = new HashMap<String, ProgressJob>();

    public ImagePullProgressHandler(IDockerConnection connection, String image) {
        this.image = image;
        this.connection = (DockerConnection)connection;
    }

    public void processMessage(IDockerProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.stopAllJobs();
            throw new DockerImagePullFailedException(this.image, message.error());
        }
        String id = message.id();
        if (id != null) {
            ProgressJob p = this.progressJobs.get(id);
            if (p == null) {
                String status = message.status();
                if (!status.contains(DVMessages.getString(IMAGE_PULLING))) {
                    if (status.equals(DVMessages.getString(IMAGE_DOWNLOAD_COMPLETE)) || status.contains(DVMessages.getString(IMAGE_DOWNLOADING_ALREADY_EXISTS)) || status.contains(DVMessages.getString(IMAGE_DOWNLOADING_VERIFIED)) || status.equals(DVMessages.getString(IMAGE_PULL_COMPLETE))) {
                        this.connection.getImages(true);
                    } else if (status.startsWith(DVMessages.getString(IMAGE_DOWNLOADING))) {
                        ProgressJob newJob = new ProgressJob(DVMessages.getFormattedString(IMAGE_DOWNLOADING_JOBNAME, this.image), DVMessages.getFormattedString(IMAGE_DOWNLOADING_IMAGE, id));
                        newJob.setUser(false);
                        newJob.setPriority(30);
                        newJob.schedule();
                        this.progressJobs.put(id, newJob);
                    }
                }
            } else {
                IDockerProgressDetail detail;
                String status = message.status();
                if (status.equals(DVMessages.getString(IMAGE_DOWNLOAD_COMPLETE)) || status.contains(DVMessages.getString(IMAGE_DOWNLOADING_ALREADY_EXISTS)) || status.contains(DVMessages.getString(IMAGE_DOWNLOADING_VERIFIED))) {
                    p.setPercentageDone(100);
                    this.connection.getImages(true);
                } else if (status.startsWith(DVMessages.getString(IMAGE_DOWNLOADING)) && (detail = message.progressDetail()) != null && detail.current() > 0L) {
                    long percentage = detail.current() * 100L / detail.total();
                    p.setPercentageDone((int)percentage);
                }
            }
        }
    }

    private void stopAllJobs() {
        for (ProgressJob j : this.progressJobs.values()) {
            j.cancel();
        }
    }
}

