/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;

public class LabelUtils {
    public static final String CREATION_DATE_PATTERN = "yyyy-MM-dd";
    public static final String FINISHED_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.sssz";

    public static <K, V> Object reduce(Map<K, List<V>> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (Map.Entry<K, List<V>> entry : elements.entrySet()) {
            result.put(entry.getKey(), LabelUtils.reduce(entry.getValue()));
        }
        return result;
    }

    public static Object reduce(Set<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.toArray()[0];
        }
        return elements.toArray();
    }

    public static Object reduce(List<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return elements;
    }

    public static String toCreatedDate(long created) {
        return LabelUtils.toDate(created, CREATION_DATE_PATTERN);
    }

    public static String toCreatedDate(Date created) {
        return LabelUtils.toDate(created, CREATION_DATE_PATTERN);
    }

    public static String toFinishedDate(Date finished) {
        return LabelUtils.toDate(finished, FINISHED_DATE_PATTERN);
    }

    public static String toDate(Long date, String pattern) {
        long millis = Long.valueOf(date) * 1000L;
        Date d = new Date(millis);
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(d);
    }

    public static String toDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String containerPortMappingToString(IDockerPortMapping portMapping) {
        StringBuilder mappingBuffer = new StringBuilder();
        if (portMapping.getIp() != null && portMapping.getPublicPort() != 0) {
            mappingBuffer.append(portMapping.getIp()).append(':').append(portMapping.getPublicPort()).append("->");
        }
        mappingBuffer.append(portMapping.getPrivatePort()).append('/').append(portMapping.getType());
        return mappingBuffer.toString();
    }

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof IDockerPortBinding) {
            IDockerPortBinding binding = (IDockerPortBinding)value;
            String hostIp = binding.hostIp() == null || binding.hostIp().isEmpty() ? "<unspecified>" : binding.hostIp();
            String hostPort = binding.hostPort() == null || binding.hostPort().isEmpty() ? "<unspecified>" : binding.hostPort();
            return hostIp + ':' + hostPort;
        }
        return value.toString();
    }
}

