/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DockerfileEditDialog
extends Dialog {
    private static final String SAVE_LABEL = "SaveButton.label";
    private static final String CANCEL_LABEL = "CancelButton.label";
    private Composite dialogArea;
    private Text textArea;
    private IFileStore dockerFile;

    protected DockerfileEditDialog(Shell parentShell, IFileStore dockerFile) {
        super(parentShell);
        this.dockerFile = dockerFile;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String fileName = this.dockerFile.toString();
        newShell.setText(DockerfileEditDialog.shortenText((String)fileName, (Control)newShell));
    }

    protected Point getInitialSize() {
        return new Point(500, 375);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, WizardMessages.getString(SAVE_LABEL), true);
        this.createButton(parent, 1, WizardMessages.getString(CANCEL_LABEL), false);
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.dialogArea.setLayout((Layout)gridLayout);
        this.textArea = new Text(this.dialogArea, 17154);
        this.textArea.setLayoutData((Object)new GridData(4, 4, true, true));
        StringBuffer b = null;
        if (this.dockerFile.fetchInfo().exists()) {
            try {
                b = this.getFileContents();
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
            }
            if (b != null) {
                this.textArea.setText(b.toString());
            }
        }
        return this.dialogArea;
    }

    private StringBuffer getFileContents() throws IOException {
        StringBuffer b = new StringBuffer();
        try (InputStream is = null;){
            try {
                is = new BufferedInputStream(this.dockerFile.openInputStream(0, null));
                byte[] c = new byte[1024];
                while (is.read(c) != -1) {
                    b.append(new String(c));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                if (is != null) {
                    is.close();
                }
            }
        }
        return b;
    }

    private void writeFileContents() throws IOException {
        try {
            BufferedOutputStream output = new BufferedOutputStream(this.dockerFile.openOutputStream(0, null));
            byte[] bytes = this.textArea.getText().getBytes();
            if (bytes.length > 0) {
                output.write(bytes);
            }
            output.close();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void okPressed() {
        try {
            this.writeFileContents();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }
}

