/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImagePushPage
extends WizardPage {
    private static final String NAME = "ImagePush.name";
    private static final String TITLE = "ImagePush.title";
    private static final String DESC = "ImagePush.desc";
    private static final String NAME_LABEL = "ImagePushName.label";
    private static final String NAME_TOOLTIP = "ImagePushName.toolTip";
    private Text nameText;
    private Combo nameCombo;
    private IDockerImage image;
    private String tag;
    private ModifyListener Listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ImagePushPage.this.validate();
        }
    };

    public ImagePushPage() {
        this(null);
    }

    public ImagePushPage(IDockerImage image) {
        super(WizardMessages.getString(NAME));
        this.image = image;
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getImageTag() {
        return this.tag;
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        String name = null;
        name = this.nameText != null ? this.nameText.getText() : this.nameCombo.getText();
        if (name.length() == 0) {
            complete = false;
        }
        if (!error) {
            this.setErrorMessage(null);
            this.tag = name;
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(WizardMessages.getString(NAME_LABEL));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)nameLabel);
        if (this.image == null || this.image.repoTags().size() == 0) {
            this.nameText = new Text(container, 2052);
            this.nameText.addModifyListener(this.Listener);
            this.nameText.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
        } else {
            this.nameCombo = new Combo(container, 12);
            this.nameCombo.addModifyListener(this.Listener);
            this.nameCombo.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
            this.nameCombo.setItems(this.image.repoTags().toArray(new String[0]));
            this.nameCombo.setText((String)this.image.repoTags().get(0));
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameCombo);
        }
        this.setControl((Control)container);
        this.validate();
    }
}

