/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.vagrant.ui.Activator;
import org.eclipse.linuxtools.internal.vagrant.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.Messages;
import org.eclipse.linuxtools.vagrant.core.EnumVMStatus;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.IVagrantVMListener;
import org.eclipse.linuxtools.vagrant.core.VagrantService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class VagrantToolBarContributionItem
extends ContributionItem
implements IVagrantVMListener {
    private List<IVagrantVM> vms = new ArrayList<IVagrantVM>();

    public VagrantToolBarContributionItem() {
        IVagrantConnection conn = VagrantService.getInstance();
        conn.addVMListener((IVagrantVMListener)this);
        Thread t = new Thread(() -> {
            this.vms = conn.getVMs();
        });
        t.start();
    }

    public VagrantToolBarContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof IMenuManager) {
            IMenuManager mm = (IMenuManager)this.getParent();
            IContributionItem v = mm.find(this.getId());
            mm.removeAll();
            mm.add(v);
            for (IVagrantVM vm : this.vms) {
                EnumVMStatus containerStatus = EnumVMStatus.fromStatusMessage((String)vm.state());
                ImageDescriptor img = containerStatus == EnumVMStatus.RUNNING ? SWTImagesFactory.DESC_CONTAINER_STARTED : SWTImagesFactory.DESC_CONTAINER_STOPPED;
                MenuManager vmM = new MenuManager(vm.name(), img, null);
                for (IAction act : this.getApplicableActions(vm)) {
                    vmM.add(act);
                }
                mm.add((IContributionItem)vmM);
            }
        }
    }

    private List<IAction> getApplicableActions(IVagrantVM vm) {
        EnumVMStatus containerStatus = EnumVMStatus.fromStatusMessage((String)vm.state());
        ArrayList<IAction> list = new ArrayList<IAction>();
        if (containerStatus == EnumVMStatus.RUNNING) {
            list.add(this.createAction(Messages.VagrantToolBarContributionItem_stop, "org.eclipse.linuxtools.vagrant.ui.commands.stopVM", SWTImagesFactory.DESC_STOP, vm));
            list.add(this.createAction(Messages.VagrantToolBarContributionItem_destroy, "org.eclipse.linuxtools.vagrant.ui.commands.destroyVM", SWTImagesFactory.DESC_REMOVE, vm));
            list.add(this.createAction(Messages.VagrantToolBarContributionItem_ssh, "org.eclipse.linuxtools.vagrant.ui.commands.sshVM", SWTImagesFactory.DESC_CONSOLE, vm));
        } else {
            list.add(this.createAction(Messages.VagrantToolBarContributionItem_start, "org.eclipse.linuxtools.vagrant.ui.commands.startVM", SWTImagesFactory.DESC_START, vm));
        }
        list.add(this.createAction(Messages.VagrantToolBarContributionItem_open, "org.eclipse.linuxtools.vagrant.ui.commands.openVFile", SWTImagesFactory.DESC_FILE, vm));
        return list;
    }

    private IAction createAction(String label, final String id, ImageDescriptor img, final IVagrantVM vm) {
        return new Action(label, img){

            public void run() {
                VagrantToolBarContributionItem.this.execute(id, (IStructuredSelection)new StructuredSelection((Object)vm));
            }
        };
    }

    private void execute(String id, IStructuredSelection selection) {
        Command command;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command2 = command = service != null ? service.getCommand(id) : null;
        if (command != null && command.isDefined()) {
            try {
                ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                IEvaluationContext ctx = handlerSvc.getCurrentState();
                ctx = new EvaluationContext(ctx, (Object)selection);
                ctx.addVariable("selection", (Object)selection);
                handlerSvc.executeCommandInContext(pCmd, null, ctx);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isDirty() {
        return true;
    }

    public void listChanged(IVagrantConnection connection, List<IVagrantVM> list) {
        this.vms = list;
        if (this.getParent() instanceof IMenuManager) {
            IMenuManager mm = (IMenuManager)this.getParent();
            Display.getDefault().asyncExec(() -> mm.update(false));
        }
    }
}

