/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.spotify.docker.client.messages.ImageSearchResult;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ImageSearchResultV2 {
    @JsonProperty(value="repositories")
    private List<String> repositories;

    public List<ImageSearchResult> getRepositories() {
        ArrayList<ImageSearchResult> result = new ArrayList<ImageSearchResult>();
        for (String repo : this.repositories) {
            result.add(new ImageResultV2(repo));
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("results", this.getRepositories()).toString();
    }

    private class ImageResultV2
    extends ImageSearchResult {
        private String name;

        public ImageResultV2(String name) {
            this.name = name;
        }

        public String getDescription() {
            return "";
        }

        public boolean isOfficial() {
            return false;
        }

        public boolean isAutomated() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public int getStarCount() {
            return 0;
        }
    }
}

