/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RepositoryTag
implements IRepositoryTag,
Comparable<IRepositoryTag> {
    @JsonProperty(value="layer")
    private String layer;
    @JsonProperty(value="name")
    private String name;

    public RepositoryTag() {
    }

    public RepositoryTag(String name, String layer) {
        this.layer = layer;
        this.name = name;
    }

    @Override
    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("layer", (Object)this.getLayer()).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryTag other = (RepositoryTag)obj;
        if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int compareTo(IRepositoryTag other) {
        try {
            String[] thisParts = this.getName().split("\\.");
            String[] thatParts = other.getName().split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            int i = 0;
            while (true) {
                int thatPart;
                if (i >= length) {
                    return 0;
                }
                int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
                if (thisPart < thatPart) {
                    return 1;
                }
                if (thisPart > thatPart) {
                    return -1;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return other.getName().compareTo(this.getName());
        }
    }
}

