/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor.assist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class CompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension3 {
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private String fAdditionalProposalInfo;

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, String additionalProposalInfo) {
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fReplacementString.length(), 0);
    }

    public String getDisplayString() {
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new DefaultInformationControlCreator();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return null;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return 0;
    }

    private static class DefaultInformationControlCreator
    implements IInformationControlCreator {
        private DefaultInformationControlCreator() {
        }

        public IInformationControl createInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, true);
        }
    }
}

