/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.docker.ui.DynamicTreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ContainerTreeGroup
extends EventManager
implements ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private List expandedTreeNodes = new ArrayList();
    private ITreeContentProvider treeContentProvider;
    private ITreeContentProvider dynamicTreeContentProvider;
    private ILabelProvider treeLabelProvider;
    private TreeViewer treeViewer;

    public ContainerTreeGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ITreeContentProvider dynamicTreeContentProvider, ILabelProvider treeLabelProvider, int style, int width, int height) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.dynamicTreeContentProvider = dynamicTreeContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.createContents(parent, width, height, style);
    }

    public void aboutToOpen() {
        Object primary;
        this.currentTreeSelection = null;
        Object[] elements = this.treeContentProvider.getElements(this.root);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
        this.treeViewer.getControl().setFocus();
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createTreeViewer(composite, width, height);
        this.initialize();
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2052);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new DynamicTreeViewer(tree, this.dynamicTreeContentProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    protected void notifySelectionChangeListeners(final SelectionChangedEvent event) {
        Object[] array = this.getListeners();
        int i = 0;
        while (i < array.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.addListenerObject(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.removeListenerObject(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selectedElement;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.currentTreeSelection = selectedElement = selection.getFirstElement();
        this.notifySelectionChangeListeners(event);
    }

    public Object getCurrentSelection() {
        return this.currentTreeSelection;
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
        this.initialize();
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeComparator(ViewerComparator comparator) {
        this.treeViewer.setComparator(comparator);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object item = event.getElement();
        if (!this.expandedTreeNodes.contains(item)) {
            this.expandedTreeNodes.add(item);
            this.dynamicTreeContentProvider.getChildren(item);
            Object[] children = this.treeContentProvider.getElements(item);
            int i = 0;
            while (i < children.length) {
                this.dynamicTreeContentProvider.getElements(children[i]);
                ++i;
            }
        }
    }
}

