/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnection2;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.jobs.RetrieveImageHierarchyJob;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenInHierarchyViewCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        final IDockerConnection2 currentConnection = (IDockerConnection2)CommandUtils.getCurrentConnection(activePart);
        final RetrieveImageHierarchyJob retrieveImageHierarchyJob = new RetrieveImageHierarchyJob(currentConnection, CommandUtils.getSelectedElement(activePart));
        retrieveImageHierarchyJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (retrieveImageHierarchyJob.getImageHierarchy() == null) {
                    Activator.logWarningMessage((String)CommandMessages.getString("command.showIn.imageHierarchyView.failure.missingHierarchy"));
                }
                Display.getDefault().asyncExec(() -> {
                    try {
                        DockerImageHierarchyView dockerImageHierarchyView = (DockerImageHierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView");
                        dockerImageHierarchyView.setConnection((IDockerConnection)currentConnection);
                        dockerImageHierarchyView.show(retrieveImageHierarchyJob.getImageHierarchy());
                    }
                    catch (PartInitException e) {
                        Activator.logErrorMessage((String)CommandMessages.getString("command.showIn.imageHierarchyView.failure"), (Throwable)e);
                    }
                });
            }
        });
        retrieveImageHierarchyJob.schedule();
        return null;
    }
}

