/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRun;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunImageCommandHandler
extends AbstractHandler {
    private static final String ERROR_CREATING_CONTAINER = "ContainerCreateError.msg";
    private static final String ERROR_REMOVING_CONTAINER = "ContainerRemoveError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerImage selectedImage = CommandUtils.getSelectedImage(activePart);
        if (selectedImage == null) {
            Activator.log(new DockerException(DVMessages.getString("RunImageUnableToRetrieveError.msg")));
        } else {
            try {
                ImageRun wizard = new ImageRun(selectedImage);
                boolean runImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
                if (runImage) {
                    DockerContainerConfig containerConfig = wizard.getDockerContainerConfig();
                    IDockerHostConfig hostConfig = wizard.getDockerHostConfig();
                    RunImageCommandHandler.runImage(selectedImage, (IDockerContainerConfig)containerConfig, hostConfig, wizard.getDockerContainerName(), wizard.removeWhenExits());
                }
            }
            catch (CoreException | DockerException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    public static void runImage(final IDockerImage image, final IDockerContainerConfig containerConfig, final IDockerHostConfig hostConfig, final String containerName, final boolean removeWhenExits) {
        final IDockerConnection connection = image.getConnection();
        if (containerConfig.tty()) {
            Display.getDefault().asyncExec(() -> {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            });
        }
        Job runImageJob = new Job(DVMessages.getString("RunImageCreateContainer.job")){

            protected IStatus run(IProgressMonitor monitor) {
                IDockerContainer container;
                String containerId;
                block10: {
                    IStatus iStatus;
                    block11: {
                        monitor.beginTask(DVMessages.getString("RunImageRunningTask.msg"), 2);
                        containerId = null;
                        SubMonitor createContainerMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        createContainerMonitor.beginTask(DVMessages.getString("RunImageCreatingContainerTask.msg"), 1);
                        containerId = ((DockerConnection)connection).createContainer(containerConfig, hostConfig, containerName);
                        container = ((DockerConnection)connection).getContainer(containerId);
                        createContainerMonitor.done();
                        if (!monitor.isCanceled()) break block10;
                        iStatus = Status.CANCEL_STATUS;
                        String tmpContainerId = containerId;
                        if (!removeWhenExits) break block11;
                        Job waitContainerJob = new Job(this, CommandMessages.getString("RunImageCommandHandler.waitContainer.label"), tmpContainerId, connection){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ String val$tmpContainerId;
                            private final /* synthetic */ IDockerConnection val$connection;
                            {
                                this.this$1 = var1_1;
                                this.val$tmpContainerId = string;
                                this.val$connection = iDockerConnection;
                                super($anonymous0);
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    if (this.val$tmpContainerId != null) {
                                        ((DockerConnection)this.val$connection).waitForContainer(this.val$tmpContainerId);
                                        ((DockerConnection)this.val$connection).stopLoggingThread(this.val$tmpContainerId);
                                        while (((DockerConnection)this.val$connection).loggingStatus(this.val$tmpContainerId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                                            Thread.sleep(1000L);
                                        }
                                    }
                                }
                                catch (InterruptedException | DockerException throwable) {
                                    // empty catch block
                                }
                                try {
                                    if (this.val$tmpContainerId != null) {
                                        ((DockerConnection)this.val$connection).removeContainer(this.val$tmpContainerId);
                                    }
                                }
                                catch (InterruptedException | DockerException e) {
                                    String id = this.val$tmpContainerId;
                                    Display.getDefault().syncExec(() -> 1.lambda$0(id, (Exception)e));
                                }
                                return Status.OK_STATUS;
                            }

                            private static /* synthetic */ void lambda$0(String string, Exception exception) {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_REMOVING_CONTAINER, string), (String)exception.getMessage());
                            }
                        };
                        waitContainerJob.setSystem(true);
                        waitContainerJob.schedule();
                    }
                    monitor.done();
                    return iStatus;
                }
                try {
                    try {
                        SubMonitor startContainerMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        startContainerMonitor.beginTask(DVMessages.getString("RunImageStartingContainerTask.msg"), 1);
                        RunConsole console = CommandUtils.getRunConsole(connection, container);
                        if (console != null) {
                            console.showConsole();
                            ((DockerConnection)connection).startContainer(containerId, console.getOutputStream());
                        } else {
                            ((DockerConnection)connection).startContainer(containerId, null);
                        }
                        startContainerMonitor.done();
                        LaunchConfigurationUtils.createRunImageLaunchConfiguration(image, containerConfig, hostConfig, containerName, removeWhenExits);
                    }
                    catch (InterruptedException | DockerException e) {
                        Display.getDefault().syncExec(() -> 1.lambda$0(containerConfig, (Exception)e));
                        String tmpContainerId = containerId;
                        if (removeWhenExits) {
                            Job waitContainerJob = new /* invalid duplicate definition of identical inner class */;
                            waitContainerJob.setSystem(true);
                            waitContainerJob.schedule();
                        }
                        monitor.done();
                    }
                }
                catch (Throwable throwable) {
                    String tmpContainerId = containerId;
                    if (removeWhenExits) {
                        Job waitContainerJob = new /* invalid duplicate definition of identical inner class */;
                        waitContainerJob.setSystem(true);
                        waitContainerJob.schedule();
                    }
                    monitor.done();
                    throw throwable;
                }
                String tmpContainerId = containerId;
                if (removeWhenExits) {
                    Job waitContainerJob = new /* invalid duplicate definition of identical inner class */;
                    waitContainerJob.setSystem(true);
                    waitContainerJob.schedule();
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private static /* synthetic */ void lambda$0(IDockerContainerConfig iDockerContainerConfig, Exception exception) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_CREATING_CONTAINER, iDockerContainerConfig.image()), (String)exception.getMessage());
            }
        };
        runImageJob.schedule();
    }
}

