/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection2;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;

public class RetrieveImageHierarchyJob
extends Job {
    private final IDockerConnection2 connection;
    private final Object selectedElement;
    private IDockerImageHierarchyNode imageHierarchy;

    public RetrieveImageHierarchyJob(IDockerConnection2 connection, Object selectedElement) {
        super(JobMessages.getString("RetrieveImageHierarchyJob.title"));
        this.connection = connection;
        this.selectedElement = selectedElement;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(JobMessages.getString("RetrieveImageHierarchyJob.title"), 1);
            if (this.selectedElement instanceof IDockerContainer) {
                this.imageHierarchy = this.connection.resolveImageHierarchy((IDockerContainer)this.selectedElement);
            } else if (this.selectedElement instanceof IDockerImage) {
                this.imageHierarchy = this.connection.resolveImageHierarchy((IDockerImage)this.selectedElement);
            } else {
                Activator.log(new DockerException(JobMessages.getFormattedString("RetrieveImageHierarchyJob.error", this.selectedElement.getClass().getName())));
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public IDockerImageHierarchyNode getImageHierarchy() {
        return this.imageHierarchy;
    }
}

