/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.propertytesters;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.DockerConnectionWatcher;
import org.eclipse.ui.PlatformUI;

public class ConnectionPropertyTester
extends PropertyTester {
    public static final String EXISTS_ACTIVE_CONNECTION = "existsActiveConnection";
    public static final String CONNECTION_ESTABLISHED = "connectionIsEstablished";
    @Deprecated
    public static final String EXISTS_ANY_CONNECTION = "existsAnyConnection";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return expectedValue.equals(false);
        }
        switch (property) {
            case "existsActiveConnection": {
                return expectedValue.equals(DockerConnectionWatcher.getInstance().getConnection() != null);
            }
            case "existsAnyConnection": {
                return expectedValue.equals(DockerConnectionManager.getInstance().hasConnections());
            }
            case "connectionIsEstablished": {
                return this.isConnectionEstablished(receiver, property, args, expectedValue);
            }
        }
        return false;
    }

    private boolean isConnectionEstablished(Object receiver, String property, Object[] args, Object expectedValue) {
        IDockerConnection connection;
        if (receiver instanceof List) {
            if (!((List)receiver).isEmpty()) {
                return this.isConnectionEstablished(((List)receiver).get(0), property, args, expectedValue);
            }
            return this.isConnectionEstablished(DockerConnectionWatcher.getInstance().getConnection(), property, args, expectedValue);
        }
        if (receiver instanceof IAdaptable && (connection = (IDockerConnection)((IAdaptable)receiver).getAdapter(IDockerConnection.class)) != null) {
            return this.isConnectionEstablished(connection, property, args, expectedValue);
        }
        if (receiver instanceof IDockerConnection) {
            return expectedValue.equals(((IDockerConnection)receiver).getState() == EnumDockerConnectionState.ESTABLISHED);
        }
        return false;
    }
}

