/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerImageFactory;
import org.junit.Test;

public class DockerImageTest {
    @Test
    public void shouldExtractRepoFromRepoTag() {
        String repoTag = "foo:latest";
        String repo = DockerImage.extractRepo((String)"foo:latest");
        Assertions.assertThat((String)repo).isEqualTo((Object)"foo");
    }

    @Test
    public void shouldExtractRepoFromOrgRepoTag() {
        String repoTag = "org/foo:latest";
        String repo = DockerImage.extractRepo((String)"org/foo:latest");
        Assertions.assertThat((String)repo).isEqualTo((Object)"org/foo");
    }

    @Test
    public void shouldExtractRepoFromOrgRepo() {
        String repoTag = "org/foo";
        String repo = DockerImage.extractRepo((String)"org/foo");
        Assertions.assertThat((String)repo).isEqualTo((Object)"org/foo");
    }

    @Test
    public void shouldExtractRepoFromRepo() {
        String repoTag = "foo";
        String repo = DockerImage.extractRepo((String)"foo");
        Assertions.assertThat((String)repo).isEqualTo((Object)"foo");
    }

    @Test
    public void shouldExtractTagFromRepoTag() {
        String repoTag = "foo:latest";
        String repo = DockerImage.extractTag((String)"foo:latest");
        Assertions.assertThat((String)repo).isEqualTo((Object)"latest");
    }

    @Test
    public void shouldExtractTagFromOrgRepoTag() {
        String repoTag = "org/foo:latest";
        String repo = DockerImage.extractTag((String)"org/foo:latest");
        Assertions.assertThat((String)repo).isEqualTo((Object)"latest");
    }

    @Test
    public void shouldNotExtractTagFromOrgRepo() {
        String repoTag = "org/foo";
        String repo = DockerImage.extractTag((String)"org/foo");
        Assertions.assertThat((String)repo).isNull();
    }

    @Test
    public void shouldNotExtractTagFromRepo() {
        String repoTag = "foo";
        String repo = DockerImage.extractTag((String)"foo");
        Assertions.assertThat((String)repo).isNull();
    }

    @Test
    public void shouldExtractTagsByRepo() {
        List<String> repoTags = Arrays.asList("foo", "foo:latest", "foo:1.0", "org/foo", "org/foo:1.0", "org/foo:latest");
        Map tagsByRepo = DockerImage.extractTagsByRepo(repoTags);
        Assertions.assertThat((Map)tagsByRepo).containsEntry((Object)"foo", Arrays.asList("1.0", "latest"));
        Assertions.assertThat((Map)tagsByRepo).containsEntry((Object)"org/foo", Arrays.asList("1.0", "latest"));
    }

    @Test
    public void shouldExtractEmptyTagsByRepo() {
        List<String> repoTags = Arrays.asList("foo");
        Map tagsByRepo = DockerImage.extractTagsByRepo(repoTags);
        Assertions.assertThat((Map)tagsByRepo).hasSize(1).contains(new MapEntry[]{MapEntry.entry((Object)"foo", Collections.emptyList())});
    }

    @Test
    public void shouldDuplicateImageByRepo() {
        IDockerImage fooImage = MockDockerImageFactory.id("sha256:foo_image").name("foo_image", "foo_image_alias:alias").build();
        List result = DockerImage.duplicateImageByRepo((IDockerImage)fooImage).collect(Collectors.toList());
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat((String)((IDockerImage)result.get(0)).id()).isEqualTo((Object)"sha256:foo_image");
        Assertions.assertThat((String)((IDockerImage)result.get(0)).repo()).isEqualTo((Object)"foo_image");
        Assertions.assertThat((List)((IDockerImage)result.get(0)).tags()).isEmpty();
        Assertions.assertThat((String)((IDockerImage)result.get(1)).id()).isEqualTo((Object)"sha256:foo_image");
        Assertions.assertThat((String)((IDockerImage)result.get(1)).repo()).isEqualTo((Object)"foo_image_alias");
        Assertions.assertThat((List)((IDockerImage)result.get(1)).tags()).containsExactly((Object[])new String[]{"alias"});
    }
}

