/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import com.spotify.docker.client.DockerClient;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CommandUtilsSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerExplorerViewBot;
    private DockerExplorerView dockerExplorerView;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();

    @Before
    public void lookupDockerExplorerView() {
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open Docker Explorer view: " + e.getMessage()));
            }
        });
        this.dockerExplorerViewBot = SWTUtils.getSWTBotView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerView = (DockerExplorerView)this.dockerExplorerViewBot.getViewReference().getView(true);
        this.bot.views().stream().filter(v -> ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerContainersView") || ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerImagesView")).forEach(v -> v.close());
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainersCategory() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem containers = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers");
        containers.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainer() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem container = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar");
        container.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainerLinksCategory() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.link("/foo:/bar/foo").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem links = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Links");
        links.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainerLink() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.link("/foo:/bar/foo").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem link = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Links", "foo (foo)");
        link.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainerVolumesCategory() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.volume("/path/to/host:/path/to/container:Z,ro").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem volumes = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Volumes");
        volumes.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainerVolume() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.volume("/path/to/host:/path/to/container:Z,ro").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem volume = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Volumes", "/path/to/host");
        volume.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainerPortsCategory() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.port("8080/tcp", "0.0.0.0", "8080").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem ports = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Ports");
        ports.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedContainerPort() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.port("8080/tcp", "0.0.0.0", "8080").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem port = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Ports", "0.0.0.0:8080 -> 8080 (tcp)");
        port.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedImagesCategory() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem images = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Images");
        images.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }

    @Test
    public void shouldRetrieveConnectionFromSelectedImage() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem image = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Images", "foo");
        image.select();
        Assertions.assertThat((Object)CommandUtils.getCurrentConnection((IWorkbenchPart)this.dockerExplorerView)).isEqualTo((Object)dockerConnection);
    }
}

