/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockDockerHostConfigFactory {
    public static Builder publishAllPorts(boolean publishAllPorts) {
        return new Builder().publishAllPorts(publishAllPorts);
    }

    public static Builder networkMode(String networkMode) {
        return new Builder().networkMode(networkMode);
    }

    public static class Builder {
        private final IDockerHostConfig hostConfig = (IDockerHostConfig)Mockito.mock(IDockerHostConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

        private Builder() {
        }

        public Builder publishAllPorts(boolean publishAllPorts) {
            Mockito.when((Object)this.hostConfig.publishAllPorts()).thenReturn((Object)publishAllPorts);
            return this;
        }

        public Builder networkMode(String networkMode) {
            Mockito.when((Object)this.hostConfig.networkMode()).thenReturn((Object)networkMode);
            return this;
        }

        public IDockerHostConfig build() {
            return this.hostConfig;
        }
    }
}

