/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class SyncFileSystemStructureProvider
implements IImportStructureProvider {
    private final IPath source;
    private final IPath destination;
    private final List<String> ignoredRelativePaths;

    private SyncFileSystemStructureProvider(IPath source, IPath destination, List<String> ignoredRelativePaths) {
        this.source = source;
        this.destination = destination;
        this.ignoredRelativePaths = ignoredRelativePaths;
    }

    public List<File> getChildren(Object element) {
        File folder = (File)element;
        String[] children = folder.list();
        int childrenLength = children == null ? 0 : children.length;
        ArrayList<File> result = new ArrayList<File>(childrenLength);
        int i = 0;
        while (i < childrenLength) {
            File sourceFile = new File(folder, children[i]);
            IPath relativeSourcePath = new Path(sourceFile.getAbsolutePath()).makeRelativeTo(this.source);
            if (!this.ignoredRelativePaths.contains(relativeSourcePath.lastSegment())) {
                if (sourceFile.isDirectory() && !this.ignoredRelativePaths.contains(relativeSourcePath.lastSegment())) {
                    result.addAll(this.getChildren(sourceFile));
                } else {
                    IPath relativeDestinationPath = this.destination.append(relativeSourcePath);
                    File destinationFile = new File(relativeDestinationPath.toOSString());
                    if (!destinationFile.exists() || destinationFile.lastModified() < sourceFile.lastModified()) {
                        result.add(sourceFile);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public InputStream getContents(Object element) {
        try {
            return new FileInputStream((File)element);
        }
        catch (FileNotFoundException e) {
            IDEWorkbenchPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getFullPath(Object element) {
        return ((File)element).getPath();
    }

    public String getLabel(Object element) {
        File file = (File)element;
        String name = file.getName();
        if (name.length() == 0) {
            return file.getPath();
        }
        return name;
    }

    public boolean isFolder(Object element) {
        return ((File)element).isDirectory();
    }

    /* synthetic */ SyncFileSystemStructureProvider(IPath iPath, IPath iPath2, List list, SyncFileSystemStructureProvider syncFileSystemStructureProvider) {
        this(iPath, iPath2, list);
    }

    public static class Builder {
        private final IPath source;
        private final IPath destination;
        private final List<String> ignoredRelativePaths = new ArrayList<String>();

        public Builder(IPath source, IPath destination) {
            this.source = source;
            this.destination = destination;
        }

        public Builder ignoreRelativeSourcePaths(String ... relativePaths) {
            this.ignoredRelativePaths.addAll(Arrays.asList(relativePaths));
            return this;
        }

        public SyncFileSystemStructureProvider build() {
            return new SyncFileSystemStructureProvider(this.source, this.destination, this.ignoredRelativePaths, null);
        }
    }
}

