/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionStorageManagerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;

public class DockerConnectionManagerUtils {
    public static void configureConnectionManager(IDockerConnection ... connections) {
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connections);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
    }

    public static void configureConnectionManager(IDockerConnectionStorageManager connectionStorageManager) {
        DockerConnectionManager.getInstance().setConnectionStorageManager(connectionStorageManager);
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView dockerExplorerBotView = SWTUtils.getSWTBotView(bot, "org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        SWTBotView dockerContainersBotView = SWTUtils.getSWTBotView(bot, "org.eclipse.linuxtools.docker.ui.dockerContainersView");
        SWTUtils.syncExec(() -> {
            DockerContainersView dockerContainersView;
            DockerExplorerView dockerExplorerView;
            DockerConnectionManager.getInstance().reloadConnections();
            if (dockerExplorerBotView != null && (dockerExplorerView = (DockerExplorerView)dockerExplorerBotView.getViewReference().getView(false)) != null) {
                dockerExplorerView.getCommonViewer().refresh();
                dockerExplorerView.showConnectionsOrExplanations();
            }
            if (dockerContainersBotView != null && (dockerContainersView = (DockerContainersView)dockerContainersBotView.getViewReference().getView(false)) != null) {
                dockerContainersView.getViewer().refresh();
            }
        });
    }
}

