/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.validators;

import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BuildDockerImageUtilsTest {
    @Parameterized.Parameter(value=0)
    public String imageName;
    @Parameterized.Parameter(value=1)
    public String expectedRepository;
    @Parameterized.Parameter(value=2)
    public String expectedName;
    @Parameterized.Parameter(value=3)
    public String expectedTag;

    private static Object[] match(String imageName, String expectedRepository, String expectedName, String expectedTag) {
        return new Object[]{imageName, expectedRepository, expectedName, expectedTag};
    }

    @Parameterized.Parameters(name="{0} -> {1}/{2}:{3}")
    public static Object[][] data() {
        return new Object[][]{BuildDockerImageUtilsTest.match("", null, null, null), BuildDockerImageUtilsTest.match("\u00a3", null, null, null), BuildDockerImageUtilsTest.match("wildfly", null, "wildfly", null), BuildDockerImageUtilsTest.match("jboss/", null, null, null), BuildDockerImageUtilsTest.match("jboss/wildfly", "jboss", "wildfly", null), BuildDockerImageUtilsTest.match("jboss/wildfly:", null, null, null), BuildDockerImageUtilsTest.match("jboss/wildfly:latest", "jboss", "wildfly", "latest"), BuildDockerImageUtilsTest.match("localhost/wildfly/", null, null, null), BuildDockerImageUtilsTest.match("localhost/jboss/wildfly", "localhost/jboss", "wildfly", null), BuildDockerImageUtilsTest.match("localhost/jboss/wildfly:", null, null, null), BuildDockerImageUtilsTest.match("localhost/jboss/wildfly:latest", "localhost/jboss", "wildfly", "latest"), BuildDockerImageUtilsTest.match("localhost/jboss/wildfly:9", "localhost/jboss", "wildfly", "9"), BuildDockerImageUtilsTest.match("localhost/jboss/wildfly:9.", null, null, null), BuildDockerImageUtilsTest.match("localhost/jboss/wildfly:9.0.1.Final", "localhost/jboss", "wildfly", "9.0.1.Final"), BuildDockerImageUtilsTest.match("localhost:", null, null, null), BuildDockerImageUtilsTest.match("localhost:5000", null, "localhost", "5000"), BuildDockerImageUtilsTest.match("localhost:5000/", null, null, null), BuildDockerImageUtilsTest.match("localhost:5000/jboss/wildfly", "jboss", "wildfly", null), BuildDockerImageUtilsTest.match("localhost:5000/jboss/wildfly/", null, null, null), BuildDockerImageUtilsTest.match("localhost:5000/jboss/wildfly", "jboss", "wildfly", null), BuildDockerImageUtilsTest.match("localhost:5000/jboss/wildfly:", null, null, null), BuildDockerImageUtilsTest.match("localhost:5000/jboss/wildfly:latest", "jboss", "wildfly", "latest")};
    }

    @Test
    public void verifyRepository() {
        String actualRepository = BuildDockerImageUtils.getRepository((String)this.imageName);
        Assert.assertEquals((Object)this.expectedRepository, (Object)actualRepository);
    }

    @Test
    public void verifyName() {
        String actualName = BuildDockerImageUtils.getName((String)this.imageName);
        Assert.assertEquals((Object)this.expectedName, (Object)actualName);
    }

    @Test
    public void verifyTag() {
        String actualTagName = BuildDockerImageUtils.getTag((String)this.imageName);
        Assert.assertEquals((Object)this.expectedTag, (Object)actualTagName);
    }
}

