/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import com.spotify.docker.client.DockerClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerImageHierarchyViewAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.MenuAssertion;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TabDescriptorAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TestLoggerRule;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class DockerContainersViewSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerContainersViewBot;
    private DockerContainersView dockerContainersView;
    private SWTBotView dockerExplorerBotView;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public TestLoggerRule watcher = new TestLoggerRule();
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();

    @Before
    public void setup() {
        this.bot = new SWTWorkbenchBot();
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("defaultcon", new String[0]).status("Running").build()).image(MockImageFactory.id("987654321abcde").name("default:1", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Default", client).withDefaultTCPConnectionSettings();
        dockerConnection.removeContainerListener((IDockerContainerListener)DockerContainerRefreshManager.getInstance());
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerContainersView");
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open Docker Explorer view: " + e.getMessage()));
            }
        });
        this.dockerContainersViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerContainersView");
        this.dockerContainersView = (DockerContainersView)this.dockerContainersViewBot.getViewReference().getView(true);
        this.dockerExplorerBotView = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
    }

    private SWTBotTableItem selectContainerInTable(String containerName) {
        SWTBotTableItem tableItem = SWTUtils.getListItem(this.dockerContainersViewBot.bot().table(), containerName);
        Assertions.assertThat((Object)tableItem).isNotNull();
        return tableItem.click().select();
    }

    private void selectContainersInTable(String ... items) {
        SWTBotTable table = this.dockerContainersViewBot.bot().table();
        Assertions.assertThat((Object)table).isNotNull();
        table.select(items);
    }

    @Test
    public void defaultContainersTest() {
        SWTUtils.syncAssert(() -> {
            Object[] containers = this.dockerContainersView.getViewer().getTable().getItems();
            Assertions.assertThat((Object[])containers).hasSize(1);
            Assertions.assertThat((String)containers[0].getText(0)).isEqualTo((Object)"defaultcon");
        });
    }

    @Test
    public void shouldRemoveListenersWhenClosingView() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerBotView, "Test").select();
        dockerConnection.removeContainerListener((IDockerContainerListener)DockerContainerRefreshManager.getInstance());
        Assertions.assertThat((List)dockerConnection.getContainerListeners()).hasSize(2);
        this.dockerContainersViewBot.close();
        Assertions.assertThat((List)dockerConnection.getContainerListeners()).hasSize(1);
    }

    @Test
    public void shouldNotRemoveListenersWhenNoSelectedConnectionBeforeClosingView() {
        this.dockerExplorerBotView.close();
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        dockerConnection.removeContainerListener((IDockerContainerListener)DockerContainerRefreshManager.getInstance());
        Assertions.assertThat((List)dockerConnection.getContainerListeners()).hasSize(0);
        this.dockerContainersViewBot.close();
        Assertions.assertThat((List)dockerConnection.getContainerListeners()).hasSize(0);
    }

    @Test
    public void shouldOpenImageHierarchyView() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.closeView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView");
        this.selectContainerInTable("angry_bar");
        SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.dockerContainersViewBot.bot().table(), "Open Image Hierarchy").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        DockerImageHierarchyViewAssertions.assertThat((DockerImageHierarchyView)SWTUtils.getView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView")).isNotNull();
    }

    @Test
    public void shouldProvideEnabledRestartOnMultipleContainers() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("bold_eagle", new String[0]).status("Stopped").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.closeView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView");
        this.selectContainersInTable("gentle_foo", "bold_eagle", "angry_bar");
        SWTBotMenu menuCommand = this.dockerContainersViewBot.bot().table().contextMenu("Restart");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldShowSelectedContainerInPropertiesView() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build(), MockContainerInfoFactory.networkMode("host").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        PropertySheet propertySheet = SWTUtils.syncExec(() -> (PropertySheet)SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        this.dockerContainersView.setFocus();
        this.selectContainerInTable("angry_bar");
        Assertions.assertThat((Object)propertySheet.getCurrentPage()).isInstanceOf(TabbedPropertySheetPage.class);
        TabbedPropertySheetPage currentPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage();
        ((TabDescriptorAssertions)TabDescriptorAssertions.assertThat(currentPage.getSelectedTab()).isNotNull()).hasId("org.eclipse.linuxtools.docker.ui.properties.container.info");
    }
}

