/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerExplorerViewAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.MenuAssertion;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTBotTreeItemAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TabDescriptorAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TestLoggerRule;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class DockerExplorerViewSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerExplorerViewBot;
    private DockerExplorerView dockerExplorerView;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public TestLoggerRule watcher = new TestLoggerRule();
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();

    @Before
    public void setup() {
        this.bot = new SWTWorkbenchBot();
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open Docker Explorer view: " + e.getMessage()));
            }
        });
        this.dockerExplorerViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerView = (DockerExplorerView)this.dockerExplorerViewBot.getViewReference().getView(true);
        this.bot.views().stream().filter(v -> ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerContainersView") || ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerImagesView") || ((IViewReference)v.getReference()).getId().equals("org.eclipse.ui.views.PropertySheet")).forEach(v -> v.close());
    }

    @After
    public void hideMenu() {
        try {
            SWTUtils.hideMenu(this.dockerExplorerViewBot.bot().tree());
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            // empty catch block
        }
    }

    private SWTBotTreeItem selectConnectionInTreeView(String connectionName) {
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorerViewBot, connectionName);
        return connectionTreeItem.select();
    }

    private void selectContainersInTreeView(String connectionName, String ... containerNames) {
        SWTUtils.asyncExec(() -> this.dockerExplorerView.getCommonViewer().expandAll());
        SWTBotTreeItem containersTreeItem = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), connectionName, "Containers");
        SWTUtils.select(containersTreeItem, containerNames);
    }

    private void selectImagesInTreeView(String connectionName, String ... imageNames) {
        SWTUtils.asyncExec(() -> this.dockerExplorerView.getCommonViewer().expandAll());
        SWTBotTreeItem imagesTreeItem = SWTUtils.getTreeItem(this.dockerExplorerViewBot, connectionName, "Images");
        SWTUtils.asyncExec(() -> {
            SWTBotTreeItem sWTBotTreeItem2 = imagesTreeItem.expand();
        });
        SWTUtils.select(imagesTreeItem, imageNames);
    }

    @Test
    public void shouldDisplayExplanationPane() {
        ClearConnectionManagerRule.removeAllConnections(DockerConnectionManager.getInstance());
        DockerExplorerViewAssertions.assertThat(this.dockerExplorerView).isEmpty();
    }

    @Test
    public void shouldDisplayConnectionsPane() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        DockerExplorerViewAssertions.assertThat(this.dockerExplorerView).isNotEmpty();
    }

    @Test
    public void shouldRefreshImagesAndShowChanges() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem connection = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test");
        Assertions.assertThat((Object[])connection.getItems()).hasSize(2);
        SWTBotTreeItem imagesTreeItem = SWTUtils.expand(connection, "Images");
        Assertions.assertThat((int)imagesTreeItem.getItems().length).isEqualTo(0);
        DockerClient updatedClient = MockDockerClientFactory.image(MockImageFactory.name("foo/bar", new String[0]).build()).build();
        dockerConnection.setClient(updatedClient);
        this.dockerExplorerViewBot.bot().tree().select(new SWTBotTreeItem[]{imagesTreeItem});
        this.dockerExplorerViewBot.bot().tree().contextMenu("Refresh").click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        imagesTreeItem.expand();
        Conditions.waitForJobs(DockerExplorerView.class, (String)"Docker Explorer View jobs");
        Assertions.assertThat((boolean)imagesTreeItem.isExpanded()).isTrue();
        Assertions.assertThat((int)imagesTreeItem.getItems().length).isEqualTo(1);
    }

    @Test
    public void shouldRefreshContainersAndShowChanges() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> this.dockerExplorerView.getCommonViewer().expandAll());
        Conditions.waitForJobs(DockerExplorerView.class, (String)"Docker Explorer View jobs");
        SWTBotTreeItem connection = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test");
        Assertions.assertThat((Object[])connection.getItems()).hasSize(2);
        SWTBotTreeItem containersTreeItem = SWTUtils.expand(connection, "Containers");
        Assertions.assertThat((int)containersTreeItem.getItems().length).isEqualTo(0);
        DockerClient updatedClient = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        dockerConnection.setClient(updatedClient);
        this.dockerExplorerViewBot.bot().tree().select(new SWTBotTreeItem[]{containersTreeItem});
        this.dockerExplorerViewBot.bot().tree().contextMenu("Refresh").click();
        SWTUtils.asyncExec(() -> {
            SWTBotTreeItem sWTBotTreeItem2 = containersTreeItem.expand();
        });
        Assertions.assertThat((boolean)containersTreeItem.isExpanded()).isTrue();
        Assertions.assertThat((int)containersTreeItem.getItems().length).isEqualTo(1);
    }

    @Test
    public void shouldShowContainerPortMapping() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.port("8080/tcp", "0.0.0.0", "8080").port("8787/tcp", "0.0.0.0", "8787").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem containerPorts = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Ports");
        SWTBotTreeItemAssertions.assertThat(containerPorts).isExpanded().hasChildItems(2);
        SWTBotTreeItemAssertions.assertThat(containerPorts.getNode(0)).hasText("0.0.0.0:8080 -> 8080 (tcp)");
        SWTBotTreeItemAssertions.assertThat(containerPorts.getNode(1)).hasText("0.0.0.0:8787 -> 8787 (tcp)");
    }

    @Test
    public void shouldShowContainerLinks() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.link("/postgres-demo:/foo_bar/postgres1").link("/postgres-demo:/foo_bar/postgres2").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem containerLinks = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Links");
        SWTBotTreeItemAssertions.assertThat(containerLinks).isExpanded().hasChildItems(2);
        SWTBotTreeItemAssertions.assertThat(containerLinks.getNode(0)).hasText("postgres-demo (postgres1)");
        SWTBotTreeItemAssertions.assertThat(containerLinks.getNode(1)).hasText("postgres-demo (postgres2)");
    }

    @Test
    public void shouldShowContainerVolumes() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.volume("/path/to/container").volume("/path/to/host:/path/to/container").volume("/path/to/host:/path/to/container:Z,ro").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> this.dockerExplorerView.getCommonViewer().expandAll());
        SWTBotTreeItem volumesTreeItem = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers", "foo_bar", "Volumes");
        SWTBotTreeItemAssertions.assertThat(volumesTreeItem).isExpanded().hasChildItems(3);
        SWTBotTreeItemAssertions.assertThat(volumesTreeItem.getNode(0)).hasText("/path/to/container");
        SWTBotTreeItemAssertions.assertThat(volumesTreeItem.getNode(1)).hasText("/path/to/host -> /path/to/container");
        SWTBotTreeItemAssertions.assertThat(volumesTreeItem.getNode(2)).hasText("/path/to/host -> /path/to/container (Z,ro)");
    }

    @Test
    public void shouldRemainExpandedAfterRefreshOnContainersCategory() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("foo_bar", new String[0]).build(), MockContainerInfoFactory.volume("/path/to/container").port("8080/tcp", "0.0.0.0", "8080").link("/foo:/bar/foo").volume("/path/to/host:/path/to/container:Z,ro").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem containers = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test", "Containers");
        SWTBotTreeItem containerLinks = SWTUtils.expand(containers, "foo_bar", "Links");
        SWTBotTreeItem containerPorts = SWTUtils.expand(containers, "foo_bar", "Ports");
        SWTBotTreeItem containerVolumes = SWTUtils.expand(containers, "foo_bar", "Volumes");
        SWTBotTreeItemAssertions.assertThat(containerLinks).isExpanded();
        SWTBotTreeItemAssertions.assertThat(containerPorts).isExpanded();
        SWTBotTreeItemAssertions.assertThat(containerVolumes).isExpanded();
        this.dockerExplorerViewBot.bot().tree().select(new SWTBotTreeItem[]{containers});
        this.dockerExplorerViewBot.bot().tree().contextMenu("Refresh").click();
        SWTUtils.asyncExec(() -> {
            SWTBotTreeItem sWTBotTreeItem2 = containers.expand();
        });
        SWTBotTreeItemAssertions.assertThat(SWTUtils.getTreeItem(containers, "foo_bar", "Links")).isExpanded();
        SWTBotTreeItemAssertions.assertThat(SWTUtils.getTreeItem(containers, "foo_bar", "Ports")).isExpanded();
        SWTBotTreeItemAssertions.assertThat(SWTUtils.getTreeItem(containers, "foo_bar", "Volumes")).isExpanded();
    }

    @Test
    public void shouldProvideEnabledStartCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Stopped").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Start");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideDisabledStartCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Stopped").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Start");
        MenuAssertion.assertThat(menuCommand).isVisible().isNotEnabled();
    }

    @Test
    public void shouldProvideEnabledRestartCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("bold_eagle", new String[0]).status("Stopped").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "bold_eagle", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Restart");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideDisabledStopCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Stop");
        MenuAssertion.assertThat(menuCommand).isVisible().isNotEnabled();
    }

    @Test
    public void shouldProvideEnabledPauseCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Pause");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideDisabledPauseCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Up (Paused)").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.dockerExplorerViewBot.bot().tree(), "Pause");
        MenuAssertion.assertThat(menuCommand).isVisible().isNotEnabled();
    }

    @Test
    public void shouldProvideEnabledUnpauseCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Up (Paused)").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Up (Paused)").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Unpause");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideDisabledUnpauseCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Up (Paused)").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Unpause");
        MenuAssertion.assertThat(menuCommand).isVisible().isNotEnabled();
    }

    @Test
    public void shouldProvideEnabledKillCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Running").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Kill");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideDisabledKillCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Kill");
        MenuAssertion.assertThat(menuCommand).isVisible().isNotEnabled();
    }

    @Test
    public void shouldProvideEnabledRemoveCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Stopped").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Remove");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideDisabledRemoveCommandOnMultipleContainersAtOnce() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("gentle_foo", new String[0]).status("Running").build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Remove");
        MenuAssertion.assertThat(menuCommand).isVisible().isNotEnabled();
    }

    @Test
    public void shouldProvideEnabledRemoveCommandOnMultipleImagesAtOnce() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("angry_bar", new String[0]).build()).image(MockImageFactory.name("gentle_foo", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectImagesInTreeView("Test", "gentle_foo", "angry_bar");
        SWTBotMenu menuCommand = this.dockerExplorerViewBot.bot().tree().contextMenu("Remove");
        MenuAssertion.assertThat(menuCommand).isVisible().isEnabled();
    }

    @Test
    public void shouldShowSelectedConnectionInPropertiesView() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectConnectionInTreeView("Test");
        SWTUtils.getContextMenu(this.dockerExplorerViewBot.bot().tree(), "Show In", "Properties").click();
        Assertions.assertThat((boolean)this.bot.viewById("org.eclipse.ui.views.PropertySheet").isActive()).isEqualTo(true);
        SWTBotView propertiesViewBot = this.bot.viewById("org.eclipse.ui.views.PropertySheet");
        SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)propertiesViewBot.bot().tree().select(new int[]{1}), "Copy").click();
        this.dockerExplorerView = (DockerExplorerView)this.dockerExplorerViewBot.getViewReference().getView(true);
    }

    @Test
    public void shouldShowSelectedContainerInPropertiesView() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectContainersInTreeView("Test", "angry_bar");
        SWTUtils.getContextMenu(this.dockerExplorerViewBot.bot().tree(), "Show In", "Properties").click();
        Assertions.assertThat((boolean)this.bot.viewById("org.eclipse.ui.views.PropertySheet").isActive()).isEqualTo(true);
        PropertySheet propertySheet = SWTUtils.syncExec(() -> (PropertySheet)SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        Assertions.assertThat((Object)propertySheet.getCurrentPage()).isInstanceOf(TabbedPropertySheetPage.class);
        TabbedPropertySheetPage currentPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage();
        ((TabDescriptorAssertions)TabDescriptorAssertions.assertThat(currentPage.getSelectedTab()).isNotNull()).hasId("org.eclipse.linuxtools.docker.ui.properties.container.info");
    }

    @Test
    public void shouldShowSelectedImageInPropertiesView() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("angry_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        this.selectImagesInTreeView("Test", "angry_bar");
        SWTUtils.getContextMenu(this.dockerExplorerViewBot.bot().tree(), "Show In", "Properties").click();
        Assertions.assertThat((boolean)this.bot.viewById("org.eclipse.ui.views.PropertySheet").isActive()).isEqualTo(true);
        PropertySheet propertySheet = SWTUtils.syncExec(() -> (PropertySheet)SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        Assertions.assertThat((Object)propertySheet.getCurrentPage()).isInstanceOf(TabbedPropertySheetPage.class);
        TabbedPropertySheetPage currentPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage();
        ((TabDescriptorAssertions)TabDescriptorAssertions.assertThat(currentPage.getSelectedTab()).isNotNull()).hasId("org.eclipse.linuxtools.docker.ui.properties.image.info");
    }

    @Test
    public void shouldRemoveListenersWhenClosingView() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("angry_bar", new String[0]).build()).container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        dockerConnection.removeContainerListener((IDockerContainerListener)DockerContainerRefreshManager.getInstance());
        Assertions.assertThat((List)dockerConnection.getContainerListeners()).hasSize(1);
        Assertions.assertThat((List)dockerConnection.getImageListeners()).hasSize(1);
        this.dockerExplorerViewBot.close();
        Assertions.assertThat((List)dockerConnection.getContainerListeners()).hasSize(0);
        Assertions.assertThat((List)dockerConnection.getImageListeners()).hasSize(0);
    }

    @Test
    public void shouldShowAllImageVariants() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.id("1a2b3c4d5e6f7g").name("foo:1.0", "foo:latest", "bar:1.0", "bar:latest").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> this.dockerExplorerView.getCommonViewer().expandAll());
        SWTBotTreeItem imagesTreeItem = SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images");
        SWTUtils.asyncExec(() -> {
            SWTBotTreeItem sWTBotTreeItem2 = imagesTreeItem.expand();
        });
        Object[] images = imagesTreeItem.getItems();
        Assertions.assertThat((Object[])images).hasSize(2);
        Assertions.assertThat((String)images[0].getText()).startsWith((CharSequence)"bar:1.0, latest");
        Assertions.assertThat((String)images[1].getText()).startsWith((CharSequence)"foo:1.0, latest");
    }

    @Test
    public void shouldDisableConnectionWhenUnreachable() throws DockerException, InterruptedException {
        DockerClient client = MockDockerClientFactory.build();
        Mockito.when((Object)client.ping()).thenThrow(new Throwable[]{new DockerException("failed by mock")});
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem connectionTreeItem = SWTUtils.expand(this.dockerExplorerViewBot.bot().tree(), "Test");
        Assertions.assertThat((Object[])connectionTreeItem.getItems()).isEmpty();
    }

    @Test
    public void shouldRemoveAllConnectionsSimultaneously() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection1 = MockDockerConnectionFactory.from("Test1", client).withDefaultTCPConnectionSettings();
        DockerConnection dockerConnection2 = MockDockerConnectionFactory.from("Test2", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection1, dockerConnection2});
        List initialConnections = Stream.of(this.dockerExplorerViewBot.bot().tree().getAllItems()).map(item -> item.getText()).collect(Collectors.toList());
        Assertions.assertThat(initialConnections).contains((Object[])new String[]{"Test1", "Test2"});
        SWTUtils.select(this.dockerExplorerViewBot.bot().tree(), "Test1", "Test2");
        SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.dockerExplorerViewBot.bot().tree(), "Remove").click();
        List remainingConnections = Stream.of(this.dockerExplorerViewBot.bot().tree().getAllItems()).map(item -> item.getText()).collect(Collectors.toList());
        Assertions.assertThat(remainingConnections).doesNotContain((Object[])new String[]{"Test1", "Test2"});
    }
}

