/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.Image;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerImageHierarchyViewAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.MenuAssertion;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TabDescriptorAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TestLoggerRule;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class DockerImageHierarchyViewSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerExplorerViewBot;
    private DockerExplorerView dockerExplorerView;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public TestLoggerRule watcher = new TestLoggerRule();
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    private DockerConnection connection;

    @Before
    public void setupViews() {
        this.bot = new SWTWorkbenchBot();
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open Docker Explorer view: " + e.getMessage()));
            }
        });
        this.dockerExplorerViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerView = (DockerExplorerView)this.dockerExplorerViewBot.getViewReference().getView(true);
        this.bot.views().stream().filter(v -> ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView")).forEach(v -> v.close());
    }

    @Before
    public void setupData() {
        Image rootImage = MockImageFactory.id("sha256:root_image").name("root_image", new String[0]).build();
        Image fooImage1 = MockImageFactory.id("sha256:foo_image1").name("foo_image1", new String[0]).parentId("sha256:root_image").build();
        Image fooImage2 = MockImageFactory.id("sha256:foo_image2").name("foo_image2", "foo_image2_alias").parentId("sha256:foo_image1").build();
        Container fooContainer1 = MockContainerFactory.id("sha256:foo_container1").name("foo_container1", new String[0]).imageName("foo_image1").status("Up").build();
        Container fooContainer21 = MockContainerFactory.id("sha256:foo_container21").name("foo_container21", new String[0]).imageName("foo_image2").status("Exited").build();
        Container fooContainer22 = MockContainerFactory.id("sha256:foo_container22").name("foo_container22", new String[0]).imageName("foo_image2_alias").status("Up (Paused)").build();
        Image barImage1 = MockImageFactory.id("sha256:bar_image1").name("bar_image1", new String[0]).parentId("sha256:root_image").build();
        Container barContainer1 = MockContainerFactory.id("sha256:bar_container1").name("bar_container1", new String[0]).imageName("bar_image1").build();
        DockerClient client = MockDockerClientFactory.image(rootImage).image(fooImage1).container(fooContainer1).image(fooImage2).container(fooContainer21).container(fooContainer22).image(barImage1).container(barContainer1).build();
        this.connection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        this.connection.getImages(true);
        this.connection.getContainers(true);
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{this.connection});
    }

    @After
    public void hideMenu() {
        try {
            SWTUtils.hideMenu(this.dockerExplorerViewBot.bot().tree());
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            // empty catch block
        }
    }

    private List<String> getChildrenElementIds(IDockerImageHierarchyNode fooImageHierarchy) {
        return fooImageHierarchy.getChildren().stream().map(e -> {
            if (e.getElement() instanceof IDockerImage) {
                return ((IDockerImage)e.getElement()).id();
            }
            return ((IDockerContainer)e.getElement()).id();
        }).collect(Collectors.toList());
    }

    private DockerImageHierarchyView getDockerImageHierarchyView() {
        SWTBotView hierarchyViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView");
        return (DockerImageHierarchyView)hierarchyViewBot.getViewReference().getView(true);
    }

    private static SWTBotTreeItem selectImageInTreeView(SWTWorkbenchBot bot, String ... path) {
        SWTBotView dockerImageHierarchyViewBot = bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView");
        DockerImageHierarchyView dockerImageHierarchyView = (DockerImageHierarchyView)dockerImageHierarchyViewBot.getViewReference().getView(true);
        SWTUtils.asyncExec(() -> dockerImageHierarchyView.getCommonViewer().expandAll());
        return SWTUtils.getTreeItem(dockerImageHierarchyViewBot, path).select();
    }

    @Test
    public void shouldDisplayImageHierarchyViewWhenSelectingImage() {
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images", "foo_image1").select();
        this.dockerExplorerViewBot.bot().tree().contextMenu("Open Image Hierarchy").click();
        DockerImageHierarchyViewAssertions.assertThat(this.getDockerImageHierarchyView()).hasSelectedElement(this.connection.getImage("sha256:foo_image1"));
    }

    @Test
    public void shouldDisplayImageHierarchyViewWhenSelectingImageAlias() {
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images", "foo_image2_alias").select();
        this.dockerExplorerViewBot.bot().tree().contextMenu("Open Image Hierarchy").click();
        DockerImageHierarchyViewAssertions.assertThat(this.getDockerImageHierarchyView()).hasSelectedElement(this.connection.getImage("sha256:foo_image2"));
    }

    @Test
    public void shouldDisplayImageHierarchyViewWhenSelectingContainer() {
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Containers", "foo_container1").select();
        this.dockerExplorerViewBot.bot().tree().contextMenu("Open Image Hierarchy").click();
        DockerImageHierarchyViewAssertions.assertThat((DockerImageHierarchyView)SWTUtils.getView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView")).hasSelectedElement(this.connection.getContainer("sha256:foo_container1"));
    }

    @Test
    public void shouldRetrieveImageHierarchyFromRootImage() {
        IDockerImage rootImage = this.connection.getImage("sha256:root_image");
        IDockerImageHierarchyNode rootImageHierarchy = this.connection.resolveImageHierarchy(rootImage);
        Assertions.assertThat((Object)rootImageHierarchy).isNotNull();
        Assertions.assertThat((Object)rootImageHierarchy.getElement()).isEqualTo((Object)rootImage);
        Assertions.assertThat((List)rootImageHierarchy.getChildren()).hasSize(2);
        Assertions.assertThat((Object)rootImageHierarchy.getParent()).isNull();
        IDockerImageHierarchyNode fooImage1Hierarchy = rootImageHierarchy.getChild("sha256:foo_image1");
        Assertions.assertThat((Object)fooImage1Hierarchy.getParent()).isEqualTo((Object)rootImageHierarchy);
        Assertions.assertThat((List)fooImage1Hierarchy.getChildren()).hasSize(2);
    }

    @Test
    public void shouldRetrieveImageHierarchyFromIntermediateImage() {
        IDockerImage fooImage1 = this.connection.getImage("sha256:foo_image1");
        IDockerImageHierarchyNode fooImage1Hierarchy = this.connection.resolveImageHierarchy(fooImage1);
        Assertions.assertThat((Object)fooImage1Hierarchy).isNotNull();
        Assertions.assertThat((Object)fooImage1Hierarchy.getElement()).isEqualTo((Object)fooImage1);
        Assertions.assertThat(this.getChildrenElementIds(fooImage1Hierarchy)).contains((Object[])new String[]{"sha256:foo_container1", "sha256:foo_image2"});
        IDockerImage rootElement = (IDockerImage)fooImage1Hierarchy.getParent().getElement();
        Assertions.assertThat((String)rootElement.id()).isEqualTo((Object)"sha256:root_image");
        Assertions.assertThat((List)fooImage1Hierarchy.getParent().getChildren()).containsExactly((Object[])new IDockerImageHierarchyNode[]{fooImage1Hierarchy});
        IDockerImageHierarchyNode fooImage2HierarchyNode = fooImage1Hierarchy.getChild("sha256:foo_image2");
        Assertions.assertThat((Object)fooImage2HierarchyNode).isNotNull();
        Assertions.assertThat((List)fooImage2HierarchyNode.getChildren()).hasSize(2);
        IDockerImageHierarchyNode fooContainer1HierarchyNode = fooImage1Hierarchy.getChild("sha256:foo_container1");
        Assertions.assertThat((Object)fooContainer1HierarchyNode).isNotNull();
        Assertions.assertThat((List)fooContainer1HierarchyNode.getChildren()).isEmpty();
    }

    @Test
    public void shouldRetrieveImageHierarchyFromLeafImage() {
        IDockerImage fooImage2 = this.connection.getImage("sha256:foo_image2");
        IDockerImageHierarchyNode fooImage2Hierarchy = this.connection.resolveImageHierarchy(fooImage2);
        Assertions.assertThat((Object)fooImage2Hierarchy).isNotNull();
        Assertions.assertThat((Object)fooImage2Hierarchy.getElement()).isEqualTo((Object)fooImage2);
        Assertions.assertThat((List)fooImage2Hierarchy.getChildren()).hasSize(2);
        Assertions.assertThat((Object)((IDockerContainer)fooImage2Hierarchy.getChild("sha256:foo_container21").getElement())).isNotNull();
        IDockerImageHierarchyNode fooImage1Hierarchy = fooImage2Hierarchy.getParent();
        IDockerImage fooImage = (IDockerImage)fooImage1Hierarchy.getElement();
        Assertions.assertThat((String)fooImage.id()).isEqualTo((Object)"sha256:foo_image1");
        Assertions.assertThat((List)fooImage1Hierarchy.getChildren()).hasSize(1);
        Assertions.assertThat((List)fooImage1Hierarchy.getChildren()).containsExactly((Object[])new IDockerImageHierarchyNode[]{fooImage2Hierarchy});
    }

    @Test
    public void shouldRetrieveImageHierarchyFromContainerBasedOnIntermediateImage() {
        IDockerContainer fooContainer1 = this.connection.getContainer("sha256:foo_container1");
        IDockerImageHierarchyNode fooContainer1Hierarchy = this.connection.resolveImageHierarchy(fooContainer1);
        Assertions.assertThat((Object)fooContainer1Hierarchy).isNotNull();
        Assertions.assertThat((Object)fooContainer1Hierarchy.getElement()).isEqualTo((Object)fooContainer1);
        Assertions.assertThat((List)fooContainer1Hierarchy.getChildren()).isEmpty();
        IDockerImage fooImage1 = (IDockerImage)fooContainer1Hierarchy.getParent().getElement();
        Assertions.assertThat((String)fooImage1.id()).isEqualTo((Object)"sha256:foo_image1");
        Assertions.assertThat((List)fooContainer1Hierarchy.getParent().getChildren()).containsExactly((Object[])new IDockerImageHierarchyNode[]{fooContainer1Hierarchy});
    }

    @Test
    public void shouldRetrieveImageHierarchyFromContainerBasedOnLeafImage() {
        IDockerContainer barContainer1 = this.connection.getContainer("sha256:bar_container1");
        IDockerImageHierarchyNode barContainer1Hierarchy = this.connection.resolveImageHierarchy(barContainer1);
        Assertions.assertThat((Object)barContainer1Hierarchy).isNotNull();
        Assertions.assertThat((Object)barContainer1Hierarchy.getElement()).isEqualTo((Object)barContainer1);
        Assertions.assertThat((List)barContainer1Hierarchy.getChildren()).isEmpty();
        IDockerImage barImageElement = (IDockerImage)barContainer1Hierarchy.getParent().getElement();
        Assertions.assertThat((String)barImageElement.id()).isEqualTo((Object)"sha256:bar_image1");
    }

    @Test
    public void shouldShowSelectedImageInPropertiesView() {
        PropertySheet propertySheet = SWTUtils.syncExec(() -> (PropertySheet)SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root");
        SWTUtils.getContextMenu(this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Show In", "Properties").click();
        Assertions.assertThat((Object)propertySheet.getCurrentPage()).isInstanceOf(TabbedPropertySheetPage.class);
        TabbedPropertySheetPage currentPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage();
        ((TabDescriptorAssertions)TabDescriptorAssertions.assertThat(currentPage.getSelectedTab()).isNotNull()).hasId("org.eclipse.linuxtools.docker.ui.properties.image.info");
    }

    @Test
    public void shouldShowSelectedContainerInPropertiesView() {
        PropertySheet propertySheet = SWTUtils.syncExec(() -> (PropertySheet)SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_container1");
        SWTUtils.getContextMenu(this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Show In", "Properties").click();
        Assertions.assertThat((Object)propertySheet.getCurrentPage()).isInstanceOf(TabbedPropertySheetPage.class);
        TabbedPropertySheetPage currentPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage();
        ((TabDescriptorAssertions)TabDescriptorAssertions.assertThat(currentPage.getSelectedTab()).isNotNull()).hasId("org.eclipse.linuxtools.docker.ui.properties.container.info");
    }

    @Test
    public void shouldProvideEnabledRemoveCommandOnSelectedImage() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Remove");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledAddTagCommandOnSelectedImage() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Add Tag");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledPushCommandOnSelectedImage() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Push...");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledStartCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_image2", "foo_container21");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Start");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledPauseCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_container1");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Pause");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledUnpauseCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_image2", "foo_container22");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Unpause");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledKillCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_container1");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Kill");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledRemoveCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_image2", "foo_container21");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Remove");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledCommitCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_image2", "foo_container21");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Commit");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledDisplayLogCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_image2", "foo_container21");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Display Log");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }

    @Test
    public void shouldProvideEnabledRemoveLogCommandOnSelectedContainer() {
        this.shouldDisplayImageHierarchyViewWhenSelectingImage();
        DockerImageHierarchyViewSWTBotTest.selectImageInTreeView(this.bot, "root", "foo_image1", "foo_image2", "foo_container21");
        SWTBotMenu menu = SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView").bot().tree(), "Remove Log");
        MenuAssertion.assertThat(menu).isVisible().isEnabled();
    }
}

