/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.consoles;

import java.util.stream.Stream;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole;
import org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeStopAction;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class DockerComposeConsolePageParticipant
implements IConsolePageParticipant,
IDebugEventSetListener {
    private DockerComposeConsole dockerComposeConsole;
    private IPageBookViewPage dockerComposeConsolePage;
    private DockerComposeStopAction stopAction;
    private boolean dockerComposeConsoleTerminated = false;

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void init(IPageBookViewPage dockerComposeConsolePage, IConsole console) {
        this.dockerComposeConsolePage = dockerComposeConsolePage;
        this.dockerComposeConsole = (DockerComposeConsole)console;
        this.stopAction = new DockerComposeStopAction(this.dockerComposeConsole.getConnection(), this.dockerComposeConsole.getWorkingDir());
        this.configureToolBar(dockerComposeConsolePage.getSite().getActionBars().getToolBarManager());
        if (this.dockerComposeConsole.getDockerComposeProcess() == null || this.dockerComposeConsoleTerminated) {
            this.stopAction.setEnabled(false);
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    protected void configureToolBar(IToolBarManager toolBarManager) {
        toolBarManager.appendToGroup("launchGroup", (IAction)this.stopAction);
    }

    public void dispose() {
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        Stream.of(events).filter(event -> event.getSource().equals(this.dockerComposeConsole.getDockerComposeProcess())).forEach(event -> this.processEvent((DebugEvent)event));
    }

    private void processEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 4: {
                this.dockerComposeConsoleTerminated = false;
                this.stopAction.setEnabled(true);
                break;
            }
            case 8: {
                this.dockerComposeConsoleTerminated = true;
                this.stopAction.setEnabled(false);
            }
        }
    }
}

